/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.ui.editor.attribute.adapter;

import java.util.TreeSet;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultXAttributeListContentProvider;

class BusListContentProvider
extends DefaultXAttributeListContentProvider {
    private XModelObject context;

    BusListContentProvider() {
    }

    public void setContext(XModelObject context) {
        this.context = context;
    }

    protected void loadTags() {
        XModelObject f = this.context;
        while (f != null && f.getFileType() != 1) {
            f = f.getParent();
        }
        if (f == null) {
            return;
        }
        String listenerEntity = this.attribute.getModelEntity().getName();
        String prefix = this.getBusEntityPrefix(listenerEntity);
        XModelObject[] ps = f.getChildByPath("Providers").getChildren();
        TreeSet<String> set = new TreeSet<String>();
        int i = 0;
        while (i < ps.length) {
            XModelObject[] cs = ps[i].getChildren();
            int j = 0;
            while (j < cs.length) {
                String v;
                if (cs[j].getModelEntity().getAttribute("id") != null && (v = cs[j].getAttributeValue("id")) != null && v.length() > 0 && (prefix == null || cs[j].getModelEntity().getName().startsWith(prefix))) {
                    set.add(v);
                }
                ++j;
            }
            ++i;
        }
        this.tags = set.toArray(new String[0]);
    }

    private String getBusEntityPrefix(String listenerEntity) {
        if (listenerEntity == null) {
            return null;
        }
        if (listenerEntity.startsWith("ESBListener")) {
            return null;
        }
        if (listenerEntity.startsWith("ESBJCAGateway")) {
            return "ESBJMSBus";
        }
        int i = listenerEntity.indexOf("Listener");
        if (i < 0) {
            return null;
        }
        return String.valueOf(listenerEntity.substring(0, i)) + "Bus";
    }
}

