/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.ui.hyperlink;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.xml.XMLLinkHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ESBPropertyLinkHyperlinkPartitioner
extends XMLLinkHyperlinkPartitioner {
    public static final String ESB_XML_LINK_PARTITION = "org.jboss.tools.common.text.ext.xml.ESB_XML_LINK";
    static Set<String> linkPropertyNames = new HashSet<String>();
    static Set<String> classPropertyNames = new HashSet<String>();
    String propertyName = null;

    static {
        linkPropertyNames.add("smooksConfig");
        linkPropertyNames.add("resource-config");
        classPropertyNames.add("class-processor");
        classPropertyNames.add("incoming-type");
        classPropertyNames.add("message-store-class");
    }

    protected String getPartitionType() {
        if (linkPropertyNames.contains(this.propertyName)) {
            return ESB_XML_LINK_PARTITION;
        }
        if (classPropertyNames.contains(this.propertyName)) {
            return "org.jboss.tools.common.text.ext.xml.XML_CLASS";
        }
        return ESB_XML_LINK_PARTITION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            IFile documentFile = smw.getFile();
            documentFile.getProject();
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null) return false;
            if (!(n instanceof Attr)) {
                return false;
            }
            Attr a = (Attr)n;
            Element p = a.getOwnerElement();
            NamedNodeMap as = p.getAttributes();
            Node c = as.getNamedItem("name");
            if (!(c instanceof Attr)) {
                return false;
            }
            this.propertyName = ((Attr)c).getValue();
            if (linkPropertyNames.contains(this.propertyName)) {
                return true;
            }
            if (!classPropertyNames.contains(this.propertyName)) return false;
            return true;
        }
        finally {
            smw.dispose();
        }
    }
}

