/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.facet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.jboss.ide.eclipse.as.wtp.core.util.VCFUtil;
import org.jboss.ide.eclipse.as.wtp.core.vcf.OutputFoldersVirtualComponent;
import org.jboss.tools.esb.core.ESBProjectCorePlugin;
import org.jboss.tools.esb.core.component.ESBVirtualComponent;
import org.jboss.tools.esb.core.facet.IJBossESBFacetDataModelProperties;
import org.jboss.tools.esb.core.facet.JBossClassPathCommand;
import org.osgi.service.prefs.BackingStoreException;

public class JBossESBFacetInstallationDelegate
implements IDelegate {
    private IDataModel model;
    public static final String ESB_NATURE = "org.jboss.tools.esb.project.core.ESBNature";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        this.model = (IDataModel)config;
        IJavaProject jproj = JavaCore.create((IProject)project);
        this.createProjectStructure(project);
        WtpUtils.addNatures((IProject)project);
        ESBVirtualComponent factory = new ESBVirtualComponent();
        IVirtualComponent newComponent = factory.createComponent(project);
        String outputLoc = jproj.readOutputLocation().removeFirstSegments(1).toString();
        newComponent.create(0, null);
        newComponent.setMetaProperty("java-output-path", outputLoc);
        IVirtualFolder jbiRoot = newComponent.getRootFolder();
        String resourcesFolder = this.model.getStringProperty("JBoss.Project.Content_Folder");
        jbiRoot.createLink((IPath)new Path("/" + resourcesFolder), 0, null);
        OutputFoldersVirtualComponent outputFoldersComponent = new OutputFoldersVirtualComponent(project, newComponent);
        VCFUtil.addReference((IVirtualComponent)outputFoldersComponent, (IVirtualComponent)newComponent, (String)"/", null);
        JBossClassPathCommand command = new JBossClassPathCommand(project, this.model);
        IStatus status = command.executeOverride(monitor);
        if (!status.equals(Status.OK_STATUS)) {
            throw new CoreException(status);
        }
        ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
        ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
    }

    private IFile createJBossESBXML(IFolder folder) throws CoreException {
        StringBuffer emptyESB = new StringBuffer();
        String configVersion = this.model.getStringProperty("JBoss.Project.Config_Version");
        emptyESB.append("<?xml version = \"1.0\" encoding = \"UTF-8\"?>");
        emptyESB.append("\n");
        String namespace = "http://anonsvn.labs.jboss.com/labs/jbossesb/trunk/product/etc/schemas/xml/jbossesb-" + configVersion + ".xsd";
        emptyESB.append("<jbossesb xmlns=\"" + namespace + "\"");
        emptyESB.append("\n");
        String schemaLocation = "http://anonsvn.jboss.org/repos/labs/labs/jbossesb/trunk/product/etc/schemas/xml/jbossesb-" + configVersion + ".xsd";
        emptyESB.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"" + namespace + " " + schemaLocation + "\"");
        emptyESB.append("\n");
        emptyESB.append(" parameterReloadSecs=\"5\">");
        emptyESB.append("</jbossesb>");
        IFile esbfile = folder.getFile("jboss-esb.xml");
        esbfile.create((InputStream)new ByteArrayInputStream(emptyESB.toString().getBytes()), true, null);
        return esbfile;
    }

    private void createProjectStructure(IProject project) throws CoreException {
        String strContentFolder = this.model.getStringProperty("JBoss.Project.Content_Folder");
        project.setPersistentProperty(IJBossESBFacetDataModelProperties.QNAME_ESB_CONTENT_FOLDER, strContentFolder);
        String qualifier = ESBProjectCorePlugin.getDefault().getDescriptor().getUniqueIdentifier();
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode(qualifier);
        if (node != null) {
            node.putDouble("jboss.esb.project.project.version", 2.0);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        IFolder esbContent = project.getFolder(strContentFolder);
        if (!esbContent.exists()) {
            esbContent.create(true, true, null);
        }
        esbContent.getFolder("lib").create(true, true, null);
        esbContent.getFolder("META-INF").create(true, true, null);
        this.createJBossESBXML(esbContent.getFolder("META-INF"));
        project.refreshLocal(0, null);
    }

    private static void addESBNature(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        String[] current = desc.getNatureIds();
        String[] replacement = new String[current.length + 1];
        System.arraycopy(current, 0, replacement, 1, current.length);
        replacement[0] = ESB_NATURE;
        desc.setNatureIds(replacement);
        project.setDescription(desc, null);
    }
}

