/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.module;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.jboss.ide.eclipse.as.wtp.core.modules.IJBTModule;
import org.jboss.ide.eclipse.as.wtp.core.modules.JBTProjectModuleDelegate;
import org.jboss.tools.esb.core.ESBProjectCorePlugin;
import org.jboss.tools.esb.core.StatusUtils;

public class JBossESBModuleDelegate
extends JBTProjectModuleDelegate
implements IJBTModule {
    public JBossESBModuleDelegate(IProject project) {
        super(project);
    }

    public IModuleResource[] members() throws CoreException {
        double d;
        String qualifier;
        IProject p = this.getProject();
        ProjectScope context = new ProjectScope(p);
        IEclipsePreferences node = context.getNode(qualifier = ESBProjectCorePlugin.getDefault().getBundle().getSymbolicName());
        if (node != null && (d = node.getDouble("jboss.esb.project.project.version", 1.0)) < 2.0) {
            return this.legacyMembers();
        }
        return super.members();
    }

    public IModuleResource[] legacyMembers() throws CoreException {
        IProject project = this.getProject();
        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
        IVirtualFolder vf = c.getRootFolder();
        IContainer[] folders = vf.getUnderlyingFolders();
        if (folders == null || folders.length == 0) {
            throw new CoreException(StatusUtils.errorStatus("The project is not a valid JBoss ESB project."));
        }
        IContainer contentFolder = folders.length > 1 ? folders[1] : folders[0];
        IFolder configFolder = this.getProject().getFolder(contentFolder.getProjectRelativePath());
        IJavaProject javaPrj = JavaCore.create((IProject)this.getProject());
        IPath output = javaPrj.getOutputLocation();
        ArrayList mrs = new ArrayList();
        IModuleResource[] esbContent = this.getModuleResources((IPath)Path.EMPTY, (IContainer)configFolder);
        IModuleResource[] classes = this.getModuleResources((IPath)Path.EMPTY, (IContainer)this.getProject().getWorkspace().getRoot().getFolder(output));
        IModuleResource[] allResource = new IModuleResource[esbContent.length + classes.length + mrs.size()];
        System.arraycopy(esbContent, 0, allResource, 0, esbContent.length);
        System.arraycopy(classes, 0, allResource, esbContent.length, classes.length);
        if (mrs.size() > 0) {
            IModuleResource[] mr = mrs.toArray(new IModuleResource[0]);
            System.arraycopy(mr, 0, allResource, esbContent.length + classes.length, mr.length);
        }
        return allResource;
    }

    protected String getFactoryId() {
        return "org.jboss.tools.esb.project.core.moduleFactory";
    }
}

