/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.model;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XModelObjectPresentation;

public class ESBAnyElementPresentation
implements XModelObjectPresentation {
    static String TAG_ROUTE_TO = "route-to";
    static String TAG_OBJECT_PATH = "object-path";
    static String PROPERTY_DESTINATIONS = "destinations";
    static String PROPERTY_OBJECT_PATHS = "object-paths";
    static String ATTR_DESTINATION_NAME = "destination-name";
    static String ATTR_ESB = "esb";

    public String getValue(XModelObject object) {
        String tag = object.getAttributeValue("tag");
        if (TAG_ROUTE_TO.equals(tag)) {
            if (!this.checkParentPropertyName(object, PROPERTY_DESTINATIONS)) {
                return null;
            }
            return this.getAnyElementAttributeValue(object, ATTR_DESTINATION_NAME);
        }
        if (TAG_OBJECT_PATH.equals(tag)) {
            if (!this.checkParentPropertyName(object, PROPERTY_OBJECT_PATHS)) {
                return null;
            }
            return this.getAnyElementAttributeValue(object, ATTR_ESB);
        }
        return null;
    }

    private boolean checkParentPropertyName(XModelObject object, String name) {
        XModelObject p = object.getParent();
        if (p == null || !"ESBProperty".equals(p.getModelEntity().getName())) {
            return false;
        }
        return name.equals(p.getAttributeValue("name"));
    }

    private String getAnyElementAttributeValue(XModelObject object, String name) {
        String as = object.getAttributeValue("attributes");
        if (as == null || as.indexOf(name) < 0) {
            return null;
        }
        String[] s = as.split(";");
        int i = 0;
        while (i < s.length) {
            if (s[i].startsWith(name)) {
                int j = s[i].indexOf(61);
                String v = s[i].substring(j + 1).trim();
                return v.length() == 0 ? null : v;
            }
            ++i;
        }
        return null;
    }
}

