/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.model;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.filetransfer.ECFExamplesTransport;
import org.jboss.tools.project.examples.model.Category;
import org.jboss.tools.project.examples.model.Project;
import org.jboss.tools.project.examples.model.ProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectFix;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtil {
    private static final String URL = "url";
    private static final String NAME = "name";
    private static final String SITES = "sites";
    private static final String SITE = "site";
    private static final String EDITOR = "editor";
    public static final String CHEATSHEETS = "cheatsheets";
    public static final String PROTOCOL_FILE = "file";
    private static final String PROJECT_EXAMPLES_XML_EXTENSION_ID = "org.jboss.tools.project.examples.projectExamplesXml";
    private static String URL_EXT = "url";
    private static String EXPERIMENTAL_EXT = "experimental";
    private static Set<ProjectExampleSite> pluginSites;

    private ProjectUtil() {
    }

    public static Set<ProjectExampleSite> getPluginSites() {
        if (pluginSites == null) {
            pluginSites = new HashSet<ProjectExampleSite>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PROJECT_EXAMPLES_XML_EXTENSION_ID);
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configurationElements = extension.getConfigurationElements();
                ProjectExampleSite site = new ProjectExampleSite();
                site.setName(extension.getLabel());
                int j = 0;
                while (j < configurationElements.length) {
                    String experimental;
                    IConfigurationElement configurationElement = configurationElements[j];
                    if (URL_EXT.equals(configurationElement.getName())) {
                        String urlString = configurationElement.getValue();
                        URL url = ProjectUtil.getURL(urlString);
                        if (url != null) {
                            site.setUrl(url);
                        }
                    } else if (EXPERIMENTAL_EXT.equals(configurationElement.getName()) && "true".equals(experimental = configurationElement.getValue())) {
                        site.setExperimental(true);
                    }
                    ++j;
                }
                if (site.getUrl() != null) {
                    pluginSites.add(site);
                }
                ++i;
            }
        }
        return pluginSites;
    }

    public static Set<ProjectExampleSite> getUserSites() {
        IPreferenceStore store;
        String sitesAsXml;
        HashSet<ProjectExampleSite> sites = new HashSet<ProjectExampleSite>();
        ProjectExampleSite site = ProjectUtil.getSite(ProjectUtil.getProjectExamplesXml());
        if (site != null) {
            sites.add(site);
        }
        if ((sitesAsXml = (store = ProjectExamplesActivator.getDefault().getPreferenceStore()).getString("userSites")) != null && sitesAsXml.trim().length() > 0) {
            Element rootElement = ProjectUtil.parseDocument(sitesAsXml);
            if (!rootElement.getNodeName().equals(SITES)) {
                ProjectExamplesActivator.log(Messages.ProjectUtil_Invalid_preferences);
                return sites;
            }
            NodeList list = rootElement.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                block8: {
                    Element entry;
                    Node node = list.item(i);
                    short type = node.getNodeType();
                    if (type == 1 && (entry = (Element)node).getNodeName().equals(SITE)) {
                        String name = entry.getAttribute(NAME);
                        String urlString = entry.getAttribute(URL);
                        if (name != null && name.trim().length() > 0 && urlString != null && urlString.trim().length() > 0) {
                            URL url = null;
                            try {
                                url = new URL(urlString);
                            }
                            catch (MalformedURLException malformedURLException) {
                                ProjectExamplesActivator.log(Messages.ProjectUtil_Invalid_preferences);
                                break block8;
                            }
                            site = new ProjectExampleSite();
                            site.setName(name);
                            site.setUrl(url);
                            site.setExperimental(true);
                            site.setEditable(true);
                            sites.add(site);
                        }
                    }
                }
                ++i;
            }
        }
        return sites;
    }

    private static Set<ProjectExampleSite> getSites() {
        HashSet<ProjectExampleSite> sites = new HashSet<ProjectExampleSite>();
        sites.addAll(ProjectUtil.getPluginSites());
        sites.addAll(ProjectUtil.getUserSites());
        return sites;
    }

    private static ProjectExampleSite getSite(String url) {
        if (url != null) {
            ProjectExampleSite site = new ProjectExampleSite();
            try {
                site.setUrl(new URL(url));
            }
            catch (MalformedURLException e) {
                ProjectExamplesActivator.log(e);
                return null;
            }
            site.setExperimental(true);
            site.setName(Messages.ProjectUtil_Test);
            return site;
        }
        return null;
    }

    private static URL getURL(String urlString) {
        if (urlString != null && urlString.trim().length() > 0) {
            urlString = urlString.trim();
            try {
                URL url = new URL(urlString);
                return url;
            }
            catch (MalformedURLException e) {
                ProjectExamplesActivator.log(e);
            }
        }
        return null;
    }

    public static List<Category> getProjects() {
        Set<ProjectExampleSite> sites = ProjectUtil.getSites();
        ArrayList<Category> list = new ArrayList<Category>();
        Category other = Category.OTHER;
        try {
            for (ProjectExampleSite site : sites) {
                boolean showExperimentalSites = ProjectExamplesActivator.getDefault().getPreferenceStore().getBoolean("showExperimentalSites");
                if (!showExperimentalSites && site.isExperimental()) continue;
                File file = ProjectUtil.getProjectExamplesFile(site.getUrl(), "projectExamples", ".xml", null);
                if (file == null || !file.exists() || !file.isFile()) {
                    ProjectExamplesActivator.log(NLS.bind((String)Messages.ProjectUtil_Invalid_URL, (Object)site.getUrl().toString()));
                    continue;
                }
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(file);
                NodeList projects = doc.getElementsByTagName("project");
                int len = projects.getLength();
                int i = 0;
                while (i < len) {
                    Node node = projects.item(i);
                    Project project = new Project();
                    Category category = other;
                    if (node.getNodeType() == 1) {
                        Element element = (Element)node;
                        NodeList children = element.getChildNodes();
                        int cLen = children.getLength();
                        int j = 0;
                        while (j < cLen) {
                            Node cNode = children.item(j);
                            if (cNode.getNodeType() == 1) {
                                String includedProjects;
                                Element child = (Element)cNode;
                                String nodeName = child.getNodeName();
                                if (nodeName.equals("fixes")) {
                                    ProjectUtil.parseFixes(project, child);
                                }
                                if (nodeName.equals("category")) {
                                    String value = ProjectUtil.getContent(child);
                                    boolean found = false;
                                    for (Category cat : list) {
                                        if (!cat.getName().equals(value)) continue;
                                        category = cat;
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        category = new Category(value);
                                        list.add(category);
                                    }
                                    project.setCategory(category);
                                }
                                if (nodeName.equals(NAME)) {
                                    project.setName(ProjectUtil.getContent(child));
                                }
                                if (nodeName.equals(SITE)) {
                                    project.setSite(ProjectUtil.getContent(child));
                                }
                                if (nodeName.equals("shortDescription")) {
                                    project.setShortDescription(ProjectUtil.getContent(child));
                                }
                                if (nodeName.equals("description")) {
                                    project.setDescription(ProjectUtil.getContent(child));
                                }
                                if (nodeName.equals(URL)) {
                                    project.setUrl(ProjectUtil.getContent(child));
                                }
                                if (nodeName.equals("size")) {
                                    long size = 0L;
                                    try {
                                        size = new Long(ProjectUtil.getContent(child));
                                    }
                                    catch (Exception exception) {}
                                    project.setSize(size);
                                }
                                if (nodeName.equals("included-projects") && (includedProjects = ProjectUtil.getContent(child)) != null) {
                                    includedProjects = includedProjects.trim();
                                    StringTokenizer tokenizer = new StringTokenizer(includedProjects, ",");
                                    ArrayList<String> projectList = new ArrayList<String>();
                                    while (tokenizer.hasMoreTokens()) {
                                        projectList.add(tokenizer.nextToken());
                                    }
                                    project.setIncludedProjects(projectList);
                                }
                                if (nodeName.equals("welcome")) {
                                    project.setWelcome(true);
                                    String attribute = child.getAttribute("type");
                                    if (attribute != null && CHEATSHEETS.equals(attribute.trim())) {
                                        project.setType(attribute.trim());
                                    } else {
                                        project.setType(EDITOR);
                                    }
                                    attribute = child.getAttribute(URL);
                                    if (attribute == null || attribute.trim().length() <= 0) {
                                        project.setWelcome(false);
                                        ProjectExamplesActivator.log(Messages.ProjectUtil_Invalid_welcome_element);
                                    } else {
                                        project.setWelcomeURL(attribute.trim());
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    if (project.getSite() == null) {
                        String siteName = site.getName();
                        if (siteName == null) {
                            siteName = Messages.Project_Unknown;
                        }
                        project.setSite(siteName);
                    }
                    category.getProjects().add(project);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            ProjectExamplesActivator.log(e);
        }
        list.add(other);
        return list;
    }

    private static void parseFixes(Project project, Element node) {
        NodeList children = node.getChildNodes();
        int cLen = children.getLength();
        int i = 0;
        while (i < cLen) {
            Element child;
            String nodeName;
            Node cNode = children.item(i);
            if (cNode.getNodeType() == 1 && (nodeName = (child = (Element)cNode).getNodeName()).equals("fix")) {
                ProjectUtil.parseFix(project, child);
            }
            ++i;
        }
    }

    private static void parseFix(Project project, Element node) {
        String type = node.getAttribute("type");
        if (type == null || type.trim().length() <= 0) {
            ProjectExamplesActivator.log(Messages.ProjectUtil_Invalid_fix);
            return;
        }
        ProjectFix fix = new ProjectFix();
        fix.setType(type);
        NodeList children = node.getChildNodes();
        int cLen = children.getLength();
        int i = 0;
        while (i < cLen) {
            Element child;
            String nodeName;
            Node cNode = children.item(i);
            if (cNode.getNodeType() == 1 && (nodeName = (child = (Element)cNode).getNodeName()).equals("property")) {
                String name = child.getAttribute(NAME);
                if (name == null || name.trim().length() <= 0) {
                    ProjectExamplesActivator.log(Messages.ProjectUtil_Invalid_property);
                    return;
                }
                String value = ProjectUtil.getContent(child);
                fix.getProperties().put(name, value);
            }
            ++i;
        }
        project.getFixes().add(fix);
    }

    private static String getProjectExamplesXml() {
        String projectXML = System.getProperty("org.jboss.tools.project.examples.xml");
        if (projectXML != null && projectXML.length() > 0) {
            return projectXML;
        }
        return null;
    }

    private static String getContent(Element child) {
        String value = child.getTextContent();
        if (value == null) {
            value = "";
        }
        return value.trim();
    }

    public static File getProjectExamplesFile(URL url, String prefix, String suffix, IProgressMonitor monitor) {
        File file = null;
        if (PROTOCOL_FILE.equals(url.getProtocol())) {
            try {
                file = new File(new URI(url.toExternalForm()));
            }
            catch (Exception exception) {
                file = new File(url.getFile());
            }
            if (!file.exists()) {
                return null;
            }
        } else {
            try {
                file = File.createTempFile(prefix, suffix);
                file.deleteOnExit();
                BufferedOutputStream destination = new BufferedOutputStream(new FileOutputStream(file));
                IStatus result = ProjectUtil.getTransport().download(prefix, url.toExternalForm(), destination, monitor);
                if (!result.isOK()) {
                    ProjectExamplesActivator.getDefault().getLog().log(result);
                    return null;
                }
            }
            catch (FileNotFoundException e) {
                ProjectExamplesActivator.log(e);
                return null;
            }
            catch (IOException e) {
                ProjectExamplesActivator.log(e);
                return null;
            }
        }
        return file;
    }

    private static ECFExamplesTransport getTransport() {
        return ECFExamplesTransport.getInstance();
    }

    public static Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public static String getAsXML(Set<ProjectExampleSite> sites) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException {
        if (sites == null || sites.size() == 0) {
            return "";
        }
        Document doc = ProjectUtil.getDocument();
        Element sitesElement = doc.createElement(SITES);
        doc.appendChild(sitesElement);
        for (ProjectExampleSite site : sites) {
            Element siteElement = doc.createElement(SITE);
            siteElement.setAttribute(NAME, site.getName());
            siteElement.setAttribute(URL, site.getUrl().toString());
            sitesElement.appendChild(siteElement);
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public static Element parseDocument(String document) {
        Element root = null;
        InputStream stream = null;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                stream = new ByteArrayInputStream(document.getBytes("UTF8"));
                root = parser.parse(stream).getDocumentElement();
            }
            catch (Exception e) {
                ProjectExamplesActivator.log(e);
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    ProjectExamplesActivator.log(e2);
                }
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                ProjectExamplesActivator.log(e);
            }
        }
        return root;
    }
}

