/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.preferences.IFieldEditor;

public abstract class BaseFieldEditor
implements IFieldEditor {
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    Set<DisposeListener> disposeListeners = new HashSet<DisposeListener>();
    private Object value = new Object();
    private String labelText;
    private String nameText = null;
    Label labelControl = null;
    protected Map<Object, Object> data = null;
    private boolean enabled = true;
    private boolean editable = true;

    public BaseFieldEditor(String name, String label, Object defaultValue) {
        this.value = defaultValue;
        this.labelText = label;
        this.nameText = name;
    }

    public void doFillIntoGrid(Object parent) {
        Assert.isTrue((boolean)(parent instanceof Composite), (String)JBossWSUIMessages.Error_JBossWS_Basic_Editor_Composite);
        Assert.isTrue((boolean)(((Composite)parent).getLayout() instanceof GridLayout), (String)JBossWSUIMessages.Error_JBossWS_Basic_Editor_Support);
        Composite aComposite = (Composite)parent;
        final Control[] controls = (Control[])this.getEditorControls(aComposite);
        GridLayout gl = (GridLayout)((Composite)parent).getLayout();
        this.doFillIntoGrid(aComposite, gl.numColumns);
        if (controls.length > 0) {
            controls[0].addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    BaseFieldEditor.this.dispose();
                    controls[0].removeDisposeListener((DisposeListener)this);
                }
            });
        }
    }

    protected void doFillIntoGrid(Composite composite, int numColumns) {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public Label createLabelControl(Composite parent) {
        if (this.labelControl == null) {
            this.labelControl = new Label(parent, 262144);
            this.labelControl.setText(this.labelText);
        } else if (parent != null && this.labelControl.getParent() != parent) {
            throw new IllegalArgumentException(JBossWSUIMessages.Error_JBossWS_Basic_Editor_Different);
        }
        return this.labelControl;
    }

    public Label getLabelControl() {
        return this.createLabelControl(null);
    }

    public abstract Object[] getEditorControls(Object var1);

    public abstract Object[] getEditorControls();

    public Control[] getSwtControls() {
        return (Control[])this.getEditorControls();
    }

    public abstract int getNumberOfControls();

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return this.getValue().toString();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        Control[] controls = this.getSwtControls();
        if (controls == null) {
            return;
        }
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            control.setEnabled(enabled);
            if (control instanceof Composite) {
                this.setEnabled((Composite)control, enabled);
            }
            ++i;
        }
    }

    private void setEnabled(Composite composite, boolean enabled) {
        Control[] controls = composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            control.setEnabled(enabled);
            if (control instanceof Composite) {
                this.setEnabled((Composite)control, enabled);
            }
            ++i;
        }
    }

    public boolean setFocus() {
        return true;
    }

    public void setValue(Object newValue) {
        Object oldValue = this.value;
        this.value = newValue;
        this.pcs.firePropertyChange(this.nameText, oldValue, newValue);
    }

    public void setValueAsString(String stringValue) {
        this.value = stringValue;
    }

    public String getName() {
        return this.nameText;
    }

    public void dispose() {
        PropertyChangeListener[] listeners = this.pcs.getPropertyChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            PropertyChangeListener propertyChangeListener = listeners[i];
            this.pcs.removePropertyChangeListener(propertyChangeListener);
            ++i;
        }
    }

    public void dispose(DisposeEvent e) {
        this.dispose();
        for (DisposeListener disposeListener : this.disposeListeners) {
            disposeListener.widgetDisposed(e);
        }
        this.disposeListeners.clear();
    }

    public void addDisposeListener(DisposeListener listener) {
        this.disposeListeners.add(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.disposeListeners.remove(listener);
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean aEditable) {
        this.editable = aEditable;
    }

    public Object getData(Object key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public void setData(Object key, Object value) {
        if (this.data == null) {
            this.data = new HashMap<Object, Object>();
        }
        this.data.put(key, value);
    }
}

