/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.ws.core.classpath.JBossWSRuntime;
import org.jboss.tools.ws.ui.JBossWSUIPlugin;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.preferences.BaseFieldEditor;

public class JBossWSLibraryListFieldEditor
extends BaseFieldEditor {
    static final int GL_COLUMNS = 2;
    static final int GL_HINT_HEIGHT = 200;
    static final int TC_DEFAULT_WIDTH = 21;
    static final int TC_NAME_WIDTH = 100;
    static final int TC_VERSION_WIDTH = 50;
    static final int TC_PATH_WIDTH = 100;
    private TreeViewer listView = null;
    private Composite root = null;
    private ActionPanel actionPanel;
    private JBossWSRuntime tempJbws = new JBossWSRuntime();
    private Group jarGroup;

    public JBossWSLibraryListFieldEditor(String name, String label, JBossWSRuntime jbws) {
        super(name, label, jbws);
        if (jbws != null) {
            this.tempJbws.setUserConfigClasspath(jbws.isUserConfigClasspath());
            this.tempJbws.getLibraries().addAll(jbws.getLibraries());
        }
    }

    public Object getValue() {
        return this.tempJbws;
    }

    public Object[] getEditorControls(Object composite) {
        this.root = new Composite((Composite)composite, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.root.setLayoutData((Object)gd);
        this.root.setLayout((Layout)new GridLayout());
        this.createCheckButton(this.root);
        this.jarGroup = new Group(this.root, 0);
        this.jarGroup.setText(JBossWSUIMessages.JBossWSLibraryListFieldEditor_LIBRARY_JARS);
        gd = new GridData(1808);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.jarGroup.setVisible(false);
        this.jarGroup.setLayoutData((Object)gd);
        this.jarGroup.setLayout((Layout)new FormLayout());
        this.createListView((Composite)this.jarGroup);
        this.createActionBar((Composite)this.jarGroup);
        FormData listData = new FormData();
        listData.left = new FormAttachment(0, 5);
        listData.right = new FormAttachment((Control)this.actionPanel, -5);
        listData.top = new FormAttachment(0, 5);
        listData.bottom = new FormAttachment(100, -5);
        this.listView.getControl().setLayoutData((Object)listData);
        FormData actionsData = new FormData();
        actionsData.top = new FormAttachment(0, 5);
        actionsData.bottom = new FormAttachment(100, -5);
        actionsData.right = new FormAttachment(100, -5);
        this.actionPanel.setLayoutData(actionsData);
        this.setJarGroupStatus();
        return new Control[]{this.root};
    }

    protected void createCheckButton(Composite parent) {
        final Button btnDefault = new Button(parent, 32);
        btnDefault.setText(JBossWSUIMessages.JBossWS_Runtime_Check_Field_Default_Classpath);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        btnDefault.setLayoutData((Object)gd);
        btnDefault.setSelection(this.tempJbws.isUserConfigClasspath());
        btnDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JBossWSLibraryListFieldEditor.this.jarGroup.isVisible()) {
                    JBossWSLibraryListFieldEditor.this.jarGroup.setVisible(false);
                } else {
                    JBossWSLibraryListFieldEditor.this.jarGroup.setVisible(true);
                }
                JBossWSLibraryListFieldEditor.this.tempJbws.setUserConfigClasspath(btnDefault.getSelection());
                JBossWSLibraryListFieldEditor.this.setJarGroupStatus();
                JBossWSLibraryListFieldEditor.this.setValue(null);
            }
        });
    }

    protected void setJarGroupStatus() {
        boolean isUserConfig = this.tempJbws.isUserConfigClasspath();
        this.jarGroup.setEnabled(isUserConfig);
        this.listView.getTree().setEnabled(isUserConfig);
        this.actionPanel.setEnabled(isUserConfig);
    }

    protected void createListView(Composite parent) {
        this.listView = new TreeViewer(parent, 2816);
        this.listView.getTree().setLayoutData((Object)new GridData(1808));
        this.listView.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof JBossWSRuntime) {
                    return ((JBossWSRuntime)inputElement).getLibraries().toArray();
                }
                throw new IllegalArgumentException(JBossWSUIMessages.JBossWS_Runtime_List_Field_Editor_Inputelement_Must_Be_An_Instance_Of_List);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                viewer.refresh();
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        });
        this.listView.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){
            Image jarImg;

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                if (this.jarImg == null) {
                    ImageDescriptor jarImgDesc = JBossWSUIPlugin.getImageDescriptor("obj16/jar_obj.gif");
                    this.jarImg = jarImgDesc.createImage();
                }
                return this.jarImg;
            }

            public String getText(Object element) {
                String fullName = (String)element;
                File jarFile = new File(fullName);
                return String.valueOf(jarFile.getName()) + " - " + jarFile.getParentFile().toString();
            }
        });
        this.listView.setInput(this.getValue());
    }

    protected void createActionBar(Composite parent) {
        this.actionPanel = new ActionPanel(parent, new BaseAction[]{new AddAction(), new RemoveAction()});
        this.listView.addSelectionChangedListener((ISelectionChangedListener)this.actionPanel);
    }

    public Object[] getEditorControls() {
        return new Control[]{this.root};
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void doFillIntoGrid(Object parent) {
        Assert.isTrue((boolean)(parent instanceof Composite), (String)JBossWSUIMessages.Error_JBossWS_Basic_Editor_Composite);
        Assert.isTrue((boolean)(((Composite)parent).getLayout() instanceof GridLayout), (String)JBossWSUIMessages.Error_JBossWS_Basic_Editor_Support);
        Composite aComposite = (Composite)parent;
        this.getEditorControls(aComposite);
        GridLayout gl = (GridLayout)((Composite)parent).getLayout();
        GridData gd = new GridData();
        gd.horizontalSpan = gl.numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        ((Control)this.getEditorControls()[0]).setLayoutData((Object)gd);
    }

    public static class ActionButton
    implements IPropertyChangeListener {
        private Button button;
        private BaseAction action;

        public ActionButton(Composite parent, int style, BaseAction action) {
            this.button = new Button(parent, style);
            this.action = action;
            GridData gd = new GridData(768, 2, false, false);
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 2;
            this.button.setLayoutData((Object)gd);
            this.action.addPropertyChangeListener(this);
            this.button.setText(action.getText());
            this.button.setEnabled(action.isEnabled());
            this.button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ActionButton.this.action.run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public Control getControl() {
            return this.button;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("enabled")) {
                this.button.setEnabled(((Boolean)event.getNewValue()).booleanValue());
            }
        }
    }

    public static class ActionPanel
    extends Composite
    implements ISelectionChangedListener {
        private BaseAction[] actions = null;

        public ActionPanel(Composite parent, int style, BaseAction[] actions) {
            super(parent, style);
            this.actions = actions;
            this.setLayout((Layout)new GridLayout(1, false));
            BaseAction[] baseActionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                BaseAction action = baseActionArray[n2];
                new ActionButton(this, 8, action);
                ++n2;
            }
        }

        public ActionPanel(Composite parent, BaseAction[] actions) {
            this(parent, 0, actions);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            BaseAction[] baseActionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                BaseAction action = baseActionArray[n2];
                action.setSelection(event.getSelection());
                ++n2;
            }
        }
    }

    public class AddAction
    extends BaseAction {
        public AddAction() {
            super(JBossWSUIMessages.JBossWSLibraryListFieldEditor_ActionAdd);
            this.setEnabled(true);
        }

        protected void updateEnablement() {
        }

        public void run() {
            FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 2);
            dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
            String fileName = dialog.open();
            String[] fileNames = dialog.getFileNames();
            if (fileName != null) {
                File filePath = new File(fileName);
                filePath = filePath.getParentFile();
                int i = 0;
                while (i < fileNames.length) {
                    IPath path = new Path(filePath.getAbsolutePath()).append(fileNames[i]);
                    if (!JBossWSLibraryListFieldEditor.this.tempJbws.getLibraries().contains(path.toOSString())) {
                        JBossWSLibraryListFieldEditor.this.tempJbws.getLibraries().add(path.toOSString());
                    }
                    ++i;
                }
                JBossWSLibraryListFieldEditor.this.listView.refresh();
                JBossWSLibraryListFieldEditor.this.setValue(null);
            }
        }
    }

    public abstract class BaseAction
    extends Action {
        String[] jars;

        public BaseAction(String name) {
            super(name);
            this.jars = new String[0];
            this.updateEnablement();
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                ArrayList<String> rts = new ArrayList<String>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object jarfile = objectArray[n2];
                    rts.add((String)jarfile);
                    ++n2;
                }
                this.jars = rts.toArray(new String[0]);
            } else {
                this.jars = new String[0];
            }
            this.updateEnablement();
        }

        protected abstract void updateEnablement();
    }

    public class RemoveAction
    extends BaseAction {
        public RemoveAction() {
            super(JBossWSUIMessages.JBossWSLibraryListFieldEditor_ActionRemove);
        }

        protected void updateEnablement() {
            this.setEnabled(this.jars.length > 0);
        }

        public void run() {
            String[] stringArray = this.jars;
            int n = this.jars.length;
            int n2 = 0;
            while (n2 < n) {
                String jar = stringArray[n2];
                JBossWSLibraryListFieldEditor.this.tempJbws.getLibraries().remove(jar);
                ++n2;
            }
            JBossWSLibraryListFieldEditor.this.listView.refresh();
            JBossWSLibraryListFieldEditor.this.setValue(null);
        }
    }
}

