/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.wizards.JBossWSGenerateWizard;
import org.jboss.tools.ws.ui.wizards.JBossWSGenerateWizardValidator;

public class JBossWSGenerateSampleClassWizardPage
extends WizardPage {
    private JBossWSGenerateWizard wizard;
    private Text packageName;
    private Text className;
    private Button checkDefault;

    protected JBossWSGenerateSampleClassWizardPage(String pageName) {
        super(pageName);
        this.setTitle(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateSampleClassPage_Title);
        this.setDescription(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateSampleClassPage_Description);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createDialogArea(parent);
        this.wizard = (JBossWSGenerateWizard)this.getWizard();
        new Label(composite, 0).setText(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateSampleClassPage_Package_Label);
        this.packageName = new Text(composite, 2048);
        GridData gd = new GridData(768);
        this.packageName.setLayoutData((Object)gd);
        this.packageName.setText(this.wizard.getPackageName());
        this.packageName.setEnabled(!this.wizard.isUseDefaultClassName());
        this.packageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossWSGenerateSampleClassWizardPage.this.wizard.setPackageName(JBossWSGenerateSampleClassWizardPage.this.packageName.getText());
                JBossWSGenerateSampleClassWizardPage.this.setPageComplete(JBossWSGenerateSampleClassWizardPage.this.isPageComplete());
            }
        });
        new Label(composite, 0).setText(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateSampleClassPage_ClassName_Label);
        this.className = new Text(composite, 2048);
        gd = new GridData(768);
        this.className.setLayoutData((Object)gd);
        this.className.setText(this.updateDefaultName());
        this.className.setEnabled(!this.wizard.isUseDefaultClassName());
        this.className.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossWSGenerateSampleClassWizardPage.this.wizard.setClassName(JBossWSGenerateSampleClassWizardPage.this.className.getText());
                JBossWSGenerateSampleClassWizardPage.this.setPageComplete(JBossWSGenerateSampleClassWizardPage.this.isPageComplete());
            }
        });
        this.checkDefault = new Button(composite, 32);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.checkDefault.setLayoutData((Object)gd);
        this.checkDefault.setSelection(this.wizard.isUseDefaultClassName());
        this.checkDefault.setText(JBossWSUIMessages.JBossWS_GenerateWizard_WizardPage_CheckButton_Label);
        this.checkDefault.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (JBossWSGenerateSampleClassWizardPage.this.checkDefault.getSelection()) {
                    JBossWSGenerateSampleClassWizardPage.this.checkDefault.setSelection(true);
                    JBossWSGenerateSampleClassWizardPage.this.packageName.setText(((JBossWSGenerateSampleClassWizardPage)JBossWSGenerateSampleClassWizardPage.this).wizard.PACKAGEDEFAULT);
                    JBossWSGenerateSampleClassWizardPage.this.className.setText(((JBossWSGenerateSampleClassWizardPage)JBossWSGenerateSampleClassWizardPage.this).wizard.CLASSDEFAULT);
                } else {
                    JBossWSGenerateSampleClassWizardPage.this.checkDefault.setSelection(false);
                }
                JBossWSGenerateSampleClassWizardPage.this.packageName.setEnabled(!JBossWSGenerateSampleClassWizardPage.this.checkDefault.getSelection());
                JBossWSGenerateSampleClassWizardPage.this.className.setEnabled(!JBossWSGenerateSampleClassWizardPage.this.checkDefault.getSelection());
                JBossWSGenerateSampleClassWizardPage.this.wizard.setUseDefaultClassName(!JBossWSGenerateSampleClassWizardPage.this.checkDefault.getSelection());
            }
        });
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        return this.validate();
    }

    private Composite createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    private String updateDefaultName() {
        ServiceModel model = this.wizard.getServiceModel();
        JBossWSGenerateWizardValidator.setServiceModel(model);
        String currentName = this.wizard.getClassName();
        if (this.wizard.getProject() == null) {
            return currentName;
        }
        boolean isDynamicWebProject = false;
        try {
            if (this.wizard.getProject().getNature("org.eclipse.wst.common.project.facet.core.nature") != null) {
                isDynamicWebProject = true;
            }
        }
        catch (CoreException coreException) {}
        if (!isDynamicWebProject) {
            return currentName;
        }
        String testName = currentName;
        IStatus status = JBossWSGenerateWizardValidator.isWSClassValid(testName, this.wizard.getProject());
        int i = 1;
        while (status != null) {
            testName = String.valueOf(currentName) + i;
            this.wizard.setClassName(testName);
            model = this.wizard.getServiceModel();
            JBossWSGenerateWizardValidator.setServiceModel(model);
            status = JBossWSGenerateWizardValidator.isWSClassValid(testName, this.wizard.getProject());
            ++i;
        }
        return testName;
    }

    protected boolean validate() {
        ServiceModel model = this.wizard.getServiceModel();
        JBossWSGenerateWizardValidator.setServiceModel(model);
        IStatus status = JBossWSGenerateWizardValidator.isWSClassValid(model.getCustomClassName(), this.wizard.getProject());
        if (status != null) {
            this.setMessage(status.getMessage(), 3);
            return false;
        }
        this.setMessage(null);
        return true;
    }

    protected void refresh() {
        this.className.setText(this.updateDefaultName());
    }
}

