/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.wizards;

import java.io.File;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.ws.creation.core.commands.MergeWebXMLCommand;
import org.jboss.tools.ws.creation.core.commands.ServiceSampleCreationCommand;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.ui.JBossWSUIPlugin;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.utils.UIUtils;
import org.jboss.tools.ws.ui.wizards.JBossWSGenerateSampleClassWizardPage;
import org.jboss.tools.ws.ui.wizards.JBossWSGenerateWebXmlWizardPage;

public class JBossWSGenerateWizard
extends Wizard
implements INewWizard {
    private JBossWSGenerateWebXmlWizardPage firstPage;
    private JBossWSGenerateSampleClassWizardPage secondPage;
    String NAMEDEFAULT = "HelloWorld";
    String PACKAGEDEFAULT = "org.jboss.samples.webservices";
    String CLASSDEFAULT = "HelloWorld";
    private String serviceName = this.NAMEDEFAULT;
    private String packageName = this.PACKAGEDEFAULT;
    private String className = this.CLASSDEFAULT;
    private boolean useDefaultServiceName = true;
    private boolean useDefaultClassName = true;
    private IStructuredSelection selection;
    private IProject project;
    private static String WEB = "web.xml";
    private static String JAVA = ".java";
    private static String WEBINF = "WEB-INF";
    private IFile webFile;
    private boolean hasInited = false;

    public JBossWSGenerateWizard() {
        super.setWindowTitle(JBossWSUIMessages.JBossWS_GenerateWizard_Title);
        super.setHelpAvailable(false);
    }

    public void addPages() {
        super.addPages();
        this.firstPage = new JBossWSGenerateWebXmlWizardPage("first");
        this.secondPage = new JBossWSGenerateSampleClassWizardPage("second");
        this.addPage((IWizardPage)this.firstPage);
        this.addPage((IWizardPage)this.secondPage);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ServiceModel model = new ServiceModel();
            model.setWebProjectName(this.project.getName());
            model.addServiceClasses(new StringBuffer().append(this.getPackageName()).append(".").append(this.getClassName()).toString());
            model.setServiceName(this.getServiceName());
            model.setUpdateWebxml(true);
            model.setCustomPackage(this.getPackageName());
            File file = this.findFileByPath(String.valueOf(this.getClassName()) + JAVA, this.project.getLocation().toOSString());
            if (file != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)JBossWSUIMessages.JBossWS_GenerateWizard_MessageDialog_Title, (String)JBossWSUIMessages.Error_JBossWS_GenerateWizard_ClassName_Same);
                return false;
            }
            IStatus status = null;
            try {
                MergeWebXMLCommand mergeCommand = new MergeWebXMLCommand(model);
                status = mergeCommand.execute(null, null);
            }
            catch (ExecutionException e) {
                JBossWSUIPlugin.log(e);
            }
            if (status != null && status.getSeverity() == 4) {
                MessageDialog.openError((Shell)this.getShell(), (String)JBossWSUIMessages.JBossWS_GenerateWizard_MessageDialog_Title, (String)status.getMessage());
                return false;
            }
            try {
                new ServiceSampleCreationCommand(model).execute(null, null);
                this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ExecutionException e) {
                JBossWSUIPlugin.log(e);
                MessageDialog.openError((Shell)this.getShell(), (String)JBossWSUIMessages.JBossWS_GenerateWizard_MessageDialog_Title, (String)e.getMessage());
            }
            catch (CoreException e) {
                JBossWSUIPlugin.log(e);
                MessageDialog.openError((Shell)this.getShell(), (String)JBossWSUIMessages.JBossWS_GenerateWizard_MessageDialog_Title, (String)e.getMessage());
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        if (this.selection.getFirstElement() instanceof IProject) {
            this.project = (IProject)this.selection.getFirstElement();
        }
        if (this.project != null && JavaEEProjectUtilities.isDynamicWebProject((IProject)this.project)) {
            this.webFile = this.project.getParent().getFolder(UIUtils.getWebContentRootPath(this.project).append(WEBINF)).getFile(WEB);
        }
        this.hasInited = true;
    }

    public boolean canFinish() {
        if (this.getProject() == null) {
            if (this.firstPage != null && !this.firstPage.getControl().isDisposed() && this.firstPage.hasChanged()) {
                this.firstPage.setErrorMessage(JBossWSUIMessages.Error_JBossWSGenerateWizard_NoProjectSelected);
            }
            return false;
        }
        if (this.hasInited && (this.webFile == null || !this.webFile.exists())) {
            if (this.firstPage != null && !this.firstPage.getControl().isDisposed() && this.firstPage.hasChanged()) {
                this.firstPage.setErrorMessage(JBossWSUIMessages.Error_JBossWS_GenerateWizard_NotDynamicWebProject);
            }
            return false;
        }
        return super.canFinish();
    }

    private File findFileByPath(String name, String path) {
        File ret = null;
        File folder = new File(path);
        if (folder.isDirectory()) {
            File[] files;
            File[] fileArray = files = folder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ret = this.findFileByPath(name, file.getAbsolutePath());
                if (ret == null) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else if (name.equals(folder.getName())) {
            ret = folder;
        }
        return ret;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isUseDefaultServiceName() {
        return this.useDefaultServiceName;
    }

    public void setUseDefaultServiceName(boolean useDefaultServiceName) {
        this.useDefaultServiceName = useDefaultServiceName;
    }

    public boolean isUseDefaultClassName() {
        return this.useDefaultClassName;
    }

    public void setUseDefaultClassName(boolean useDefaultClassName) {
        this.useDefaultClassName = useDefaultClassName;
    }

    public IProject getProject() {
        return this.project;
    }

    public ServiceModel getServiceModel() {
        ServiceModel model = new ServiceModel();
        if (this.project != null) {
            model.setWebProjectName(this.project.getName());
        }
        if (this.getPackageName() != null) {
            model.addServiceClasses(new StringBuffer().append(this.getPackageName()).append(".").append(this.getClassName()).toString());
        }
        model.setServiceName(this.getServiceName());
        model.setUpdateWebxml(true);
        model.setCustomPackage(this.getPackageName());
        model.setCustomClassName(this.getClassName());
        return model;
    }

    public JBossWSGenerateWebXmlWizardPage getFirstPage() {
        return this.firstPage;
    }

    public JBossWSGenerateSampleClassWizardPage getSecondPage() {
        return this.secondPage;
    }

    public void setProject(String projectName) {
        IProject test;
        if (projectName != null && projectName.trim().length() > 0 && (test = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null) {
            this.project = test;
            if (this.project != null && JavaEEProjectUtilities.isDynamicWebProject((IProject)this.project)) {
                this.webFile = this.project.getParent().getFolder(UIUtils.getWebContentRootPath(this.project).append(WEBINF)).getFile(WEB);
            }
        }
    }
}

