/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.ui.widgets;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

public class CodeGenConfigWidget
extends SimpleWidgetDataContributor {
    private ServiceModel model;
    private Button btnRemove;
    private Button btnUpdateWebxml;
    private Button btnGenDefaultImpl;
    private Button btnExtension;

    public ServiceModel getModel() {
        return this.model;
    }

    public void setModel(ServiceModel model) {
        this.model = model;
    }

    public CodeGenConfigWidget(ServiceModel model) {
        this.model = model;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        Composite configCom = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        configCom.setLayout((Layout)layout);
        configCom.setLayoutData((Object)new GridData(1808));
        Label lblCustomPakage = new Label(configCom, 0);
        lblCustomPakage.setText(JBossWSCreationCoreMessages.Label_Custom_Package_Name);
        final Text txtCustomPkgName = new Text(configCom, 2048);
        txtCustomPkgName.setText(this.model.getCustomPackage());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        txtCustomPkgName.setLayoutData((Object)gd);
        txtCustomPkgName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeGenConfigWidget.this.model.setCustomPackage(txtCustomPkgName.getText());
            }
        });
        new Label(configCom, 0).setText(JBossWSCreationCoreMessages.Label_JaxWS_Target);
        final Combo cbSpec = new Combo(configCom, 2056);
        cbSpec.add(JBossWSCreationCoreMessages.Value_Target_0, 0);
        cbSpec.add(JBossWSCreationCoreMessages.Value_Target_1, 1);
        if (JBossWSCreationCoreMessages.Value_Target_0.equals(this.model.getTarget())) {
            cbSpec.select(0);
        } else {
            cbSpec.select(1);
        }
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        cbSpec.setLayoutData((Object)gd);
        cbSpec.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeGenConfigWidget.this.model.setTarget(cbSpec.getText());
            }
        });
        new Label(configCom, 0).setText(JBossWSCreationCoreMessages.Label_Catalog_File);
        final Text txtCatlog = new Text(configCom, 2048);
        txtCatlog.setLayoutData((Object)new GridData(768));
        Button btnCatlog = new Button(configCom, 0);
        btnCatlog.setText(JBossWSCreationCoreMessages.Label_Button_Text_Seletion);
        btnCatlog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fileLocation = new FileDialog(Display.getCurrent().getActiveShell(), 0).open();
                txtCatlog.setText(fileLocation);
                CodeGenConfigWidget.this.model.setCatalog(fileLocation);
            }
        });
        new Label(configCom, 0).setText(JBossWSCreationCoreMessages.Label_Binding_File);
        final List bindingList = new List(configCom, 2817);
        gd = new GridData(768);
        gd.heightHint = Display.getCurrent().getActiveShell().getBounds().height / 4;
        gd.verticalSpan = 3;
        bindingList.setLayoutData((Object)gd);
        this.loadBindingFiles(bindingList);
        bindingList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (bindingList.getSelectionIndex() >= 0) {
                    CodeGenConfigWidget.this.btnRemove.setEnabled(true);
                } else {
                    CodeGenConfigWidget.this.btnRemove.setEnabled(false);
                }
            }
        });
        Button btnSelect = new Button(configCom, 0);
        btnSelect.setText(JBossWSCreationCoreMessages.Label_Button_Text_Seletion);
        btnSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fileLocation = new FileDialog(Display.getCurrent().getActiveShell(), 0).open();
                if (fileLocation != null && !CodeGenConfigWidget.this.model.getBindingFiles().contains(fileLocation)) {
                    bindingList.add(fileLocation);
                    CodeGenConfigWidget.this.model.addBindingFile(fileLocation);
                }
            }
        });
        new Label(configCom, 0);
        this.btnRemove = new Button(configCom, 0);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setText(JBossWSCreationCoreMessages.Label_Button_Text_Remove);
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeGenConfigWidget.this.model.getBindingFiles().remove(bindingList.getSelectionIndex());
                bindingList.remove(bindingList.getSelectionIndex());
                if (bindingList.getSelectionIndex() == -1) {
                    CodeGenConfigWidget.this.btnRemove.setEnabled(false);
                }
            }
        });
        this.btnExtension = new Button(configCom, 32);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.btnExtension.setLayoutData((Object)gd);
        this.btnExtension.setText(JBossWSCreationCoreMessages.Label_EnableSOAP12_Binding_Extension);
        this.btnExtension.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeGenConfigWidget.this.model.setEnableSOAP12(CodeGenConfigWidget.this.btnExtension.getSelection());
            }
        });
        if (this.model.getWsScenario() != 2) {
            this.btnGenDefaultImpl = new Button(configCom, 32);
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.btnGenDefaultImpl.setLayoutData((Object)gd);
            this.btnGenDefaultImpl.setText(JBossWSCreationCoreMessages.Label_Generate_Impelemtation);
            this.btnGenDefaultImpl.setSelection(true);
            this.btnGenDefaultImpl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CodeGenConfigWidget.this.model.setGenerateImplementatoin(CodeGenConfigWidget.this.btnGenDefaultImpl.getSelection());
                    CodeGenConfigWidget.this.btnUpdateWebxml.setEnabled(CodeGenConfigWidget.this.btnGenDefaultImpl.getSelection());
                    if (!CodeGenConfigWidget.this.btnGenDefaultImpl.getSelection()) {
                        CodeGenConfigWidget.this.model.setUpdateWebxml(false);
                    } else {
                        CodeGenConfigWidget.this.model.setUpdateWebxml(CodeGenConfigWidget.this.btnUpdateWebxml.getSelection());
                    }
                }
            });
            this.btnUpdateWebxml = new Button(configCom, 32);
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.btnUpdateWebxml.setLayoutData((Object)gd);
            this.btnUpdateWebxml.setText(JBossWSCreationCoreMessages.Label_Update_Webxml);
            this.btnUpdateWebxml.setSelection(true);
            this.btnUpdateWebxml.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CodeGenConfigWidget.this.model.setUpdateWebxml(CodeGenConfigWidget.this.btnUpdateWebxml.getSelection());
                }
            });
        }
        this.updateExtensionButtonStatus();
        return this;
    }

    private void updateExtensionButtonStatus() {
        this.btnExtension.setEnabled(JBossWSCreationUtils.supportSOAP12((String)this.model.getWebProjectName()));
    }

    private void loadBindingFiles(List bindingList) {
        for (String fileLocation : this.model.getBindingFiles()) {
            bindingList.add(fileLocation);
        }
    }
}

