/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.JBossWSCreationCore;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractGenerateCodeCommand
extends AbstractDataModelOperation {
    protected ServiceModel model;
    private String cmdFileName_linux;
    private String cmdFileName_win;
    private static String JAVA_HOME = "JAVA_HOME";

    public AbstractGenerateCodeCommand(ServiceModel model) {
        this.model = model;
        this.cmdFileName_linux = this.getCommandLineFileName_linux();
        this.cmdFileName_win = this.getCommandLineFileName_win();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            String[] env;
            ArrayList<String> command;
            String commandLocation;
            IProject project;
            IStatus status;
            block22: {
                monitor.beginTask("", 100);
                monitor.subTask(JBossWSCreationCoreMessages.Progress_Message_Generating);
                status = Status.OK_STATUS;
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.model.getWebProjectName());
                String runtimeLocation = JBossWSCreationUtils.getJBossWSRuntimeLocation(project);
                commandLocation = String.valueOf(runtimeLocation) + '/' + "bin";
                Path path = new Path(commandLocation);
                command = new ArrayList<String>();
                env = this.getEnvironmentVariables(project);
                if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                    command.add("cmd.exe");
                    command.add("/c");
                    command.add(this.cmdFileName_win);
                    path = path.append(this.cmdFileName_win);
                } else {
                    command.add("sh");
                    command.add(this.cmdFileName_linux);
                    path = path.append(this.cmdFileName_linux);
                }
                if (path.toFile().getAbsoluteFile().exists()) break block22;
                IStatus iStatus = StatusUtils.errorStatus((String)NLS.bind((String)JBossWSCreationCoreMessages.Error_Message_Command_File_Not_Found, (Object[])new String[]{path.toOSString()}));
                return iStatus;
            }
            this.addCommandlineArgs(command);
            this.addCommonArgs(command, project);
            Process proc = DebugPlugin.exec((String[])command.toArray(new String[command.size()]), (File)new File(commandLocation), (String[])env);
            StringBuffer errorResult = new StringBuffer();
            StringBuffer inputResult = new StringBuffer();
            this.convertInputStreamToString(errorResult, proc.getErrorStream());
            this.convertInputStreamToString(inputResult, proc.getInputStream());
            int exitValue = proc.waitFor();
            String resultInput = inputResult.toString();
            if (exitValue != 0) {
                JBossWSCreationCore.getDefault().logError(errorResult.toString());
                JBossWSCreationCore.getDefault().logError(inputResult.toString());
                if (resultInput != null && resultInput.indexOf("javac -d") >= 0) {
                    IStatus iStatus = StatusUtils.warningStatus((String)errorResult.toString());
                    return iStatus;
                }
                IStatus iStatus = StatusUtils.errorStatus((String)errorResult.toString());
                return iStatus;
            }
            try {
                if (resultInput != null) {
                    IStatus errorStatus;
                    if (resultInput.indexOf("[ERROR]") >= 0) {
                        JBossWSCreationCore.getDefault().logWarning(resultInput);
                        errorStatus = StatusUtils.warningStatus((String)resultInput);
                        status = StatusUtils.warningStatus((String)JBossWSCreationCoreMessages.Error_Message_Failed_To_Generate_Code, (Throwable)new CoreException(errorStatus));
                    }
                    if (resultInput.indexOf("error") >= 0) {
                        JBossWSCreationCore.getDefault().logError(resultInput);
                        errorStatus = StatusUtils.errorStatus((String)resultInput);
                        status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_Failed_To_Generate_Code, (Throwable)new CoreException(errorStatus));
                    }
                }
            }
            catch (InterruptedException e) {
                JBossWSCreationCore.getDefault().logError(e);
                IStatus iStatus = StatusUtils.errorStatus((Throwable)e);
                return iStatus;
            }
            catch (CoreException e) {
                JBossWSCreationCore.getDefault().logError(e);
                IStatus iStatus = e.getStatus();
                return iStatus;
            }
            catch (Exception e) {
                JBossWSCreationCore.getDefault().logError(e);
                IStatus iStatus = StatusUtils.errorStatus((Throwable)e);
                return iStatus;
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            this.refreshProject(this.model.getWebProjectName(), monitor);
            monitor.done();
        }
    }

    private String[] getEnvironmentVariables(IProject project) {
        String[] env = null;
        String javaHome = System.getenv(JAVA_HOME);
        if (javaHome == null || !new File(javaHome).exists()) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject == null || !javaProject.exists()) {
                return null;
            }
            try {
                if (!javaProject.isOpen()) {
                    javaProject.open(null);
                }
                IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)javaProject);
                String javaLocation = vm.getInstallLocation().toString();
                env = new String[]{String.valueOf(JAVA_HOME) + "=" + javaLocation};
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
        return env;
    }

    private void addCommonArgs(List<String> command, IProject project) throws Exception {
        String projectRoot = JBossWSCreationUtils.getProjectRoot(this.model.getWebProjectName()).toOSString();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        command.add("-k");
        command.add("-s");
        command.add(JBossWSCreationUtils.getJavaProjectSrcLocation(project));
        command.add("-o");
        StringBuffer opDir = new StringBuffer();
        opDir.append(projectRoot).append('/').append(javaProject.getOutputLocation().removeFirstSegments(1).toOSString());
        command.add(opDir.toString());
        if (this.model.getWsdlURI() != null) {
            command.add(this.model.getWsdlURI());
        }
    }

    private void convertInputStreamToString(final StringBuffer result, final InputStream input) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    InputStreamReader ir = new InputStreamReader(input);
                    LineNumberReader reader = new LineNumberReader(ir);
                    String str = reader.readLine();
                    while (str != null) {
                        result.append(str).append("\t\r");
                        str = reader.readLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private void refreshProject(String project, IProgressMonitor monitor) {
        try {
            JBossWSCreationUtils.getProjectByName(project).refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
            JBossWSCreationCore.getDefault().logError(e);
        }
    }

    protected abstract void addCommandlineArgs(List<String> var1) throws Exception;

    protected abstract String getCommandLineFileName_linux();

    protected abstract String getCommandLineFileName_win();
}

