/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.JBossWSCreationCore;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationClassCreationCommand
extends AbstractDataModelOperation {
    private static final String RESOURCE_FOLDER = "src";
    private static final String PREFIX_JAXWS_ANNOTATION_CLASS = "javax.jws";
    private static final String DEFAULT_CU_SUFFIX = ".java";
    private static final String ANNOTATION_WEB_SERVICE_FULLNAME = "javax.jws.WebService";
    private static final String ANNOTATION_TYPE_NAME_WEBSERVICE = "WebService";
    private static final String ANNOTATION_PROPERTY_NAME = "name";
    private static final String ANNOTATION_PROPERTY_SERVICE_NAME = "serviceName";
    private static final String ANNOTATION_PROPERTY_ENDPOINT_INTERFACE = "endpointInterface";
    private ServiceModel model;
    private IWorkspaceRoot fWorkspaceRoot;

    public ImplementationClassCreationCommand(ServiceModel model) {
        this.model = model;
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.model.isGenImplementation()) {
            return Status.OK_STATUS;
        }
        IStatus status = Status.OK_STATUS;
        try {
            List<String> portTypes = this.model.getPortTypes();
            for (String portTypeName : portTypes) {
                this.generateImplClass(this.formatPortTypeName(portTypeName));
                String implClsName = String.valueOf(this.getImplPackageName()) + "." + this.getImplClassName(portTypeName);
                this.model.addServiceClasses(implClsName);
            }
        }
        catch (CoreException e) {
            status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_Failed_to_Generate_Implementation, (Throwable)e);
            JBossWSCreationCore.getDefault().logError(e);
        }
        catch (BadLocationException e) {
            status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_Failed_to_Generate_Implementation, (Throwable)e);
            JBossWSCreationCore.getDefault().logError(e);
        }
        return status;
    }

    private String formatPortTypeName(String portTypeName) {
        if (portTypeName == null || "".equals(portTypeName)) {
            return portTypeName;
        }
        StringBuffer buf = new StringBuffer();
        String tem = buf.append(Character.toUpperCase(portTypeName.charAt(0))).append(portTypeName.substring(1)).toString();
        return tem;
    }

    protected void generateImplClass(String portTypeName) throws CoreException, BadLocationException {
        CompilationUnit portTypeCU = this.getCompilationUnitForInterface(portTypeName);
        this.getImportsWithoutJaxwsAnnotation(portTypeCU);
        IPackageFragment pack = this.getImplPakcage();
        String implFileName = this.getJavaFileName(portTypeName);
        ICompilationUnit icu = pack.createCompilationUnit(implFileName, "", true, null);
        icu.becomeWorkingCopy(null);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        parser.setResolveBindings(false);
        parser.setFocalPosition(0);
        CompilationUnit implCu = (CompilationUnit)parser.createAST(null);
        AST ast = implCu.getAST();
        String source = icu.getBuffer().getContents();
        Document document = new Document(source);
        implCu.recordModifications();
        PackageDeclaration implPackage = ast.newPackageDeclaration();
        implPackage.setName(ast.newName(pack.getElementName()));
        implCu.setPackage(implPackage);
        this.addImportsToImplementationClass(implCu, portTypeCU, portTypeName);
        TypeDeclaration type = ast.newTypeDeclaration();
        type.setInterface(false);
        String endpoint = this.getPortTypeInterfaceFullName(portTypeName);
        NormalAnnotation ann = this.createAnnotation(ast, this.getImplClassName(portTypeName), portTypeName, endpoint);
        type.modifiers().add(ann);
        type.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        type.setName(ast.newSimpleName(this.getImplClassName(portTypeName)));
        type.superInterfaceTypes().add(ast.newSimpleType(ast.newName(portTypeName)));
        TypeDeclaration inTD = (TypeDeclaration)portTypeCU.types().get(0);
        MethodDeclaration[] methods = inTD.getMethods();
        int i = 0;
        while (i < methods.length) {
            MethodDeclaration newMethod = this.createMethodForImplClass(ast, methods[i]);
            type.bodyDeclarations().add(newMethod);
            ++i;
        }
        implCu.types().add(type);
        TextEdit edits = implCu.rewrite((IDocument)document, icu.getJavaProject().getOptions(true));
        edits.apply((IDocument)document);
        String newSource = document.get();
        icu.getBuffer().setContents(newSource);
        icu.reconcile(0, false, null, null);
        icu.commitWorkingCopy(true, null);
        icu.discardWorkingCopy();
    }

    private String getImplPackageName() {
        return this.model.getCustomPackage();
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        String str = String.valueOf(this.model.getWebProjectName()) + File.separator + RESOURCE_FOLDER;
        Path path = new Path(str);
        IResource res = this.fWorkspaceRoot.findMember((IPath)path);
        IProject prj = res.getProject();
        IJavaProject javaPrj = JavaCore.create((IProject)prj);
        return javaPrj.getPackageFragmentRoot(res);
    }

    private String getJavaFileName(String portTypeName) {
        return String.valueOf(this.getImplClassName(portTypeName)) + DEFAULT_CU_SUFFIX;
    }

    private String getImplClassName(String portTypeName) {
        String firstLetter = portTypeName.substring(0, 1);
        String implClsName = String.valueOf(firstLetter.toUpperCase()) + portTypeName.substring(1);
        implClsName = String.valueOf(implClsName) + "Impl";
        return implClsName;
    }

    private IPackageFragment getImplPakcage() throws JavaModelException {
        String implPackageName;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        IPackageFragment pack = root.getPackageFragment(implPackageName = this.getImplPackageName());
        if (!pack.exists()) {
            String packName = pack.getElementName();
            pack = root.createPackageFragment(packName, true, null);
        }
        return pack;
    }

    private String getPortTypeInterfaceFullName(String portTypeName) {
        return String.valueOf(this.model.getCustomPackage()) + "." + portTypeName;
    }

    private void addImportsToImplementationClass(CompilationUnit implCU, CompilationUnit portTypeCU, String portTypeName) {
        List<ImportDeclaration> imports = this.getImportsWithoutJaxwsAnnotation(portTypeCU);
        AST implAST = implCU.getAST();
        for (ImportDeclaration id : imports) {
            ImportDeclaration newId = implAST.newImportDeclaration();
            newId.setName(implAST.newName(id.getName().getFullyQualifiedName()));
            implCU.imports().add(newId);
        }
        ImportDeclaration importDec = implAST.newImportDeclaration();
        QualifiedName portTypeImport = implAST.newQualifiedName(implAST.newName(portTypeCU.getPackage().getName().getFullyQualifiedName()), implAST.newSimpleName(portTypeName));
        importDec.setName((Name)portTypeImport);
        implCU.imports().add(importDec);
        importDec = implAST.newImportDeclaration();
        importDec.setName(implAST.newName(ANNOTATION_WEB_SERVICE_FULLNAME));
        implCU.imports().add(importDec);
    }

    protected NormalAnnotation createAnnotation(AST ast, String name, String serviceName, String endpoint) {
        NormalAnnotation ann = ast.newNormalAnnotation();
        ann.setTypeName((Name)ast.newSimpleName(ANNOTATION_TYPE_NAME_WEBSERVICE));
        MemberValuePair member = this.createMemberValuePair(ast, ANNOTATION_PROPERTY_NAME, name);
        ann.values().add(member);
        member = this.createMemberValuePair(ast, ANNOTATION_PROPERTY_SERVICE_NAME, serviceName);
        ann.values().add(member);
        member = this.createMemberValuePair(ast, ANNOTATION_PROPERTY_ENDPOINT_INTERFACE, endpoint);
        ann.values().add(member);
        return ann;
    }

    private MemberValuePair createMemberValuePair(AST ast, String propertyName, String Value) {
        MemberValuePair member = ast.newMemberValuePair();
        member.setName(ast.newSimpleName(propertyName));
        StringLiteral value = ast.newStringLiteral();
        value.setLiteralValue(Value);
        member.setValue((Expression)value);
        return member;
    }

    protected MethodDeclaration createMethodForImplClass(AST ast, MethodDeclaration inMethod) {
        MethodDeclaration md = ast.newMethodDeclaration();
        md.setConstructor(false);
        List modifiers = md.modifiers();
        modifiers.add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        md.setName(ast.newSimpleName(inMethod.getName().getFullyQualifiedName()));
        Type sType = this.copyTypeFromOtherASTNode(ast, inMethod.getReturnType2());
        md.setReturnType2(sType);
        List parameters = inMethod.parameters();
        for (Object obj : parameters) {
            SingleVariableDeclaration implSvd = ast.newSingleVariableDeclaration();
            SingleVariableDeclaration svd = (SingleVariableDeclaration)obj;
            implSvd.setName(ast.newSimpleName(svd.getName().getFullyQualifiedName()));
            implSvd.setType(this.copyTypeFromOtherASTNode(ast, svd.getType()));
            md.parameters().add(implSvd);
        }
        Block block = ast.newBlock();
        Type returnType = inMethod.getReturnType2();
        ReturnStatement rs = ast.newReturnStatement();
        if (returnType.isPrimitiveType()) {
            if (((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.BOOLEAN)) {
                BooleanLiteral bl = ast.newBooleanLiteral(false);
                rs.setExpression((Expression)bl);
            } else if (!((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
                NumberLiteral nl = ast.newNumberLiteral();
                nl.setToken("0");
                rs.setExpression((Expression)nl);
            }
        } else if (returnType.isSimpleType()) {
            String typeName = ((SimpleType)returnType).getName().getFullyQualifiedName();
            if ("String".equals(typeName)) {
                StringLiteral sl = ast.newStringLiteral();
                sl.setLiteralValue("");
                rs.setExpression((Expression)sl);
            } else {
                rs.setExpression((Expression)ast.newNullLiteral());
            }
        } else {
            rs.setExpression((Expression)ast.newNullLiteral());
        }
        block.statements().add(rs);
        md.setBody(block);
        return md;
    }

    private Type copyTypeFromOtherASTNode(AST ast, Type type) {
        if (type instanceof PrimitiveType) {
            return ast.newPrimitiveType(((PrimitiveType)type).getPrimitiveTypeCode());
        }
        if (type instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)type;
            return ast.newSimpleType(ast.newName(simpleType.getName().getFullyQualifiedName()));
        }
        if (type instanceof ArrayType) {
            ArrayType atype = (ArrayType)type;
            return ast.newArrayType(this.copyTypeFromOtherASTNode(ast, atype.getComponentType()));
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            ParameterizedType newParaType = ast.newParameterizedType(this.copyTypeFromOtherASTNode(ast, ptype.getType()));
            for (Object arg : ptype.typeArguments()) {
                if (!(arg instanceof Type)) continue;
                Type newArg = this.copyTypeFromOtherASTNode(ast, (Type)arg);
                newParaType.typeArguments().add(newArg);
            }
            return newParaType;
        }
        if (type instanceof WildcardType) {
            WildcardType sourcetype = (WildcardType)type;
            WildcardType wtype = ast.newWildcardType();
            wtype.setBound(sourcetype.getBound());
            return wtype;
        }
        return null;
    }

    protected List<ImportDeclaration> getImportsWithoutJaxwsAnnotation(CompilationUnit cu) {
        ArrayList<ImportDeclaration> importList = new ArrayList<ImportDeclaration>();
        List imports = cu.imports();
        for (Object obj : imports) {
            ImportDeclaration id = (ImportDeclaration)obj;
            String imClsName = id.getName().getFullyQualifiedName();
            if (imClsName.startsWith(PREFIX_JAXWS_ANNOTATION_CLASS)) continue;
            importList.add(id);
        }
        return importList;
    }

    private CompilationUnit getCompilationUnitForInterface(String portTypeName) throws CoreException {
        IFile inFile = this.getServiceInterfaceFile(portTypeName);
        if (!inFile.exists()) {
            throw new CoreException(StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_Failed_To_Generate_Code));
        }
        ICompilationUnit icu = JBossWSCreationUtils.getJavaUnitFromFile(inFile);
        ASTParser astp = ASTParser.newParser((int)3);
        astp.setSource(icu);
        CompilationUnit cu = (CompilationUnit)astp.createAST(null);
        return cu;
    }

    private IFile getServiceInterfaceFile(String portTypeName) {
        IFolder pkgFolder = this.getPackageFolder();
        IFile inFile = pkgFolder.getFile(String.valueOf(portTypeName) + DEFAULT_CU_SUFFIX);
        return inFile;
    }

    private IFolder getPackageFolder() {
        IProject project = JBossWSCreationUtils.getProjectByName(this.model.getWebProjectName());
        IFolder srcFolder = project.getFolder(RESOURCE_FOLDER);
        String pkgFolderName = this.model.getCustomPackage().replace(".", File.separator);
        return srcFolder.getFolder(pkgFolderName);
    }
}

