/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import javax.wsdl.WSDLException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceClient;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.JBossWSCreationCore;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;
import org.jboss.tools.ws.creation.core.utils.WSDLPropertyReader;

public class InitialClientCommand
extends AbstractDataModelOperation {
    private ServiceModel model;
    private IWebServiceClient wsClient;
    private int scenario;

    public InitialClientCommand(ServiceModel model, IWebServiceClient wsClient, int scenario) {
        this.model = model;
        this.wsClient = wsClient;
        this.scenario = scenario;
        model.setWsScenario(scenario);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            String location = JBossWSCreationUtils.getJBossWSRuntimeLocation(JBossWSCreationUtils.getProjectByName(this.model.getWebProjectName()));
            if (location.equals("")) {
                return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_WS_Location);
            }
            if (!new Path(location).append(JBossWSCreationCoreMessages.Bin).append(JBossWSCreationCoreMessages.Command).toFile().exists()) {
                return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_WS_Location);
            }
        }
        catch (CoreException coreException) {
            return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_WS_Location);
        }
        this.model.setTarget(JBossWSCreationCoreMessages.Value_Target_0);
        if (this.scenario == 2) {
            try {
                this.model.setWsdlURI(this.wsClient.getWebServiceClientInfo().getWsdlURL());
                WSDLPropertyReader reader = new WSDLPropertyReader();
                reader.readWSDL(this.wsClient.getWebServiceClientInfo().getWsdlURL());
                this.model.setCustomPackage(reader.packageFromTargetNamespace());
                this.model.setServiceList(reader.getServiceList());
                this.model.setPortTypeList(reader.getPortTypeList());
            }
            catch (WSDLException e) {
                JBossWSCreationCore.getDefault().logError(e);
                return StatusUtils.errorStatus((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public ServiceModel getWebServiceDataModel() {
        return this.model;
    }
}

