/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import java.io.File;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jee.project.facet.WebCreateDeploymentFilesDataModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

public class MergeWebXMLCommand
extends AbstractDataModelOperation {
    private ServiceModel model;
    IStatus status;
    private static String WEB_XML = "web.xml";

    public MergeWebXMLCommand(ServiceModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.status = Status.OK_STATUS;
        if (!this.model.isUpdateWebxml()) {
            return this.status;
        }
        ServletDescriptor[] servletDescriptors = new ServletDescriptor[this.model.getServiceClasses().size()];
        List<String> serviceClasses = this.model.getServiceClasses();
        int i = 0;
        while (i < serviceClasses.size()) {
            servletDescriptors[i] = this.getServletDescriptor(serviceClasses.get(i));
            ++i;
        }
        IProject pro = JBossWSCreationUtils.getProjectByName(this.model.getWebProjectName());
        if (!this.hasWebXML(pro)) {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)pro);
            IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebCreateDeploymentFilesDataModelProvider());
            model.setProperty("ICreateDeploymentFilesDataModelProperties.GENERATE_DD", (Object)vc);
            model.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)pro);
            IDataModelOperation op = model.getDefaultOperation();
            try {
                op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException executionException) {}
        }
        this.mergeWebXML(servletDescriptors);
        return this.status;
    }

    private void mergeWebXML(final ServletDescriptor[] servletDescriptors) {
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)JBossWSCreationUtils.getProjectByName(this.model.getWebProjectName()));
        provider.modify(new Runnable(){

            public void run() {
                int i;
                WebApp webApp;
                Object object = provider.getModelObject();
                if (object instanceof WebApp) {
                    webApp = (WebApp)object;
                    i = 0;
                    while (i < servletDescriptors.length) {
                        MergeWebXMLCommand.this.addjeeServlet(JBossWSCreationUtils.getProjectByName(MergeWebXMLCommand.this.model.getWebProjectName()), servletDescriptors[i], webApp);
                        ++i;
                    }
                }
                if (object instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                    webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)object;
                    i = 0;
                    while (i < servletDescriptors.length) {
                        MergeWebXMLCommand.this.addServlet(JBossWSCreationUtils.getProjectByName(MergeWebXMLCommand.this.model.getWebProjectName()), servletDescriptors[i], (org.eclipse.jst.j2ee.webapplication.WebApp)webApp);
                        ++i;
                    }
                }
            }
        }, null);
    }

    protected void addServlet(IProject projectByName, ServletDescriptor servletDescriptor, org.eclipse.jst.j2ee.webapplication.WebApp webapp) {
        EList theServlets = webapp.getServlets();
        int i = 0;
        while (i < theServlets.size()) {
            Servlet aServlet = (Servlet)theServlets.get(i);
            if (aServlet.getServletName().equals(servletDescriptor._name)) {
                this.status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_JBossWS_GenerateWizard_WSName_Same);
                return;
            }
            ++i;
        }
        EList theServletMapplings = webapp.getServletMappings();
        int i2 = 0;
        while (i2 < theServletMapplings.size()) {
            org.eclipse.jst.j2ee.webapplication.ServletMapping aServletMapping = (org.eclipse.jst.j2ee.webapplication.ServletMapping)theServletMapplings.get(i2);
            if (aServletMapping.getName().equals(servletDescriptor._name) || aServletMapping.getUrlPattern().equals(servletDescriptor._mappings)) {
                this.status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_JBossWS_GenerateWizard_WSName_Same);
                return;
            }
            ++i2;
        }
        WebapplicationFactory factory = WebapplicationFactory.eINSTANCE;
        Servlet servlet = factory.createServlet();
        ServletType servletType = factory.createServletType();
        servlet.setWebType((WebType)servletType);
        servlet.setServletName(servletDescriptor._name);
        servletType.setClassName(servletDescriptor._className);
        if (servletDescriptor._displayName != null) {
            servlet.setDisplayName(servletDescriptor._displayName);
        }
        webapp.getServlets().add((Object)servlet);
        if (servletDescriptor._mappings != null) {
            org.eclipse.jst.j2ee.webapplication.ServletMapping servletMapping = factory.createServletMapping();
            servletMapping.setServlet(servlet);
            servletMapping.setUrlPattern(servletDescriptor._mappings);
            webapp.getServletMappings().add((Object)servletMapping);
        }
    }

    private ServletDescriptor getServletDescriptor(String clsName) {
        String servletName = this.model.getServiceName();
        if (servletName == null) {
            servletName = JBossWSCreationUtils.classNameFromQualifiedName(clsName);
        }
        if (servletName.endsWith("Impl") && servletName.length() > 4) {
            servletName = servletName.substring(0, servletName.length() - 4);
        }
        ServletDescriptor sd = new ServletDescriptor();
        sd._displayName = sd._name = servletName;
        sd._className = clsName;
        sd._mappings = String.valueOf(JBossWSCreationCoreMessages.Separator_Java) + sd._name;
        return sd;
    }

    public void addjeeServlet(IProject webProject, ServletDescriptor servletDescriptor, WebApp webapp) {
        List theServlets = webapp.getServlets();
        int i = 0;
        while (i < theServlets.size()) {
            org.eclipse.jst.javaee.web.Servlet aServlet = (org.eclipse.jst.javaee.web.Servlet)theServlets.get(i);
            if (aServlet.getServletName().equals(servletDescriptor._name)) {
                this.status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_JBossWS_GenerateWizard_WSName_Same);
                return;
            }
            ++i;
        }
        List theServletMapplings = webapp.getServletMappings();
        int i2 = 0;
        while (i2 < theServletMapplings.size()) {
            ServletMapping aServletMapping = (ServletMapping)theServletMapplings.get(i2);
            if (aServletMapping.getServletName().equals(servletDescriptor._name)) {
                this.status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_JBossWS_GenerateWizard_WSName_Same);
                return;
            }
            List list = aServletMapping.getUrlPatterns();
            if (list != null) {
                int j = 0;
                while (j < list.size()) {
                    UrlPatternType url = (UrlPatternType)list.get(j);
                    if (url.getValue().equals(servletDescriptor._mappings)) {
                        this.status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_JBossWS_GenerateWizard_WSName_Same);
                        return;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        WebFactory factory = WebFactory.eINSTANCE;
        org.eclipse.jst.javaee.web.Servlet servlet = factory.createServlet();
        servlet.setServletName(servletDescriptor._name);
        servlet.setServletClass(servletDescriptor._className);
        if (servletDescriptor._displayName != null) {
            DisplayName displayNameObj = JavaeeFactory.eINSTANCE.createDisplayName();
            displayNameObj.setValue(servletDescriptor._displayName);
            servlet.getDisplayNames().add(displayNameObj);
        }
        webapp.getServlets().add(servlet);
        if (servletDescriptor._mappings != null) {
            ServletMapping servletMapping = factory.createServletMapping();
            servletMapping.setServletName(servlet.getServletName());
            UrlPatternType url = JavaeeFactory.eINSTANCE.createUrlPatternType();
            url.setValue(servletDescriptor._mappings);
            servletMapping.getUrlPatterns().add(url);
            webapp.getServletMappings().add(servletMapping);
        }
    }

    private boolean hasWebXML(IProject pro) {
        File file = JBossWSCreationUtils.findFileByPath(WEB_XML, pro.getLocation().toOSString());
        return file != null;
    }

    public class ServletDescriptor {
        String _name;
        String _className;
        String _displayName;
        String _mappings;
    }
}

