/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarEntryResource;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ClassHyperlink
extends AbstractHyperlink {
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        try {
            IJavaElement element = null;
            IEditorPart part = null;
            String className = this.getClassName(region);
            if (className != null && className.trim().length() > 0) {
                element = this.searchForClass(className);
            }
            if (element != null) {
                part = JavaUI.openInEditor(element);
            }
            if (part != null && element != null) {
                JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)element);
            } else {
                this.openFileFailed();
            }
        }
        catch (CoreException coreException) {
            this.openFileFailed();
        }
    }

    private String getClassName(IRegion region) {
        try {
            return this.getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IJavaElement searchForClass(IJavaProject javaProject, String className) throws JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((String)className, (int)0, (int)0, (int)8);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        final ArrayList matches = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                matches.add(match);
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        try {
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        }
        catch (CoreException coreException) {}
        Iterator i = matches.iterator();
        while (i != null && i.hasNext()) {
            IJavaElement element = (IJavaElement)((SearchMatch)i.next()).getElement();
            String classQualifiedName = this.getQualifiedClassName(element);
            if (!className.equals(classQualifiedName)) continue;
            return element;
        }
        return javaProject.findType(className, (IProgressMonitor)new NullProgressMonitor());
    }

    private String getQualifiedClassName(IJavaElement element) {
        if (element instanceof IType) {
            return ((IType)element).getFullyQualifiedName('.');
        }
        return null;
    }

    private IJavaElement searchForClass(String className) {
        IProject project;
        block12: {
            block11: {
                IFile documentFile = this.getFile();
                try {
                    project = null;
                    if (documentFile == null) {
                        IWorkbenchPage workbenchPage = ExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IEditorPart activeEditorPart = workbenchPage.getActiveEditor();
                        IEditorInput editorInput = activeEditorPart.getEditorInput();
                        if (editorInput instanceof JarEntryEditorInput) {
                            JarEntryEditorInput jarEntryEditorInput = (JarEntryEditorInput)editorInput;
                            JarEntryResource jarEntryFile = (JarEntryResource)jarEntryEditorInput.getStorage();
                            IJavaProject parentProject = this.getProjectForJarResource(jarEntryFile);
                            if (parentProject != null) {
                                return this.searchForClass(parentProject, className);
                            }
                        } else if (editorInput instanceof IStorageEditorInput) {
                            IJavaProject parentProject;
                            IStorageEditorInput moeInput = (IStorageEditorInput)editorInput;
                            IStorage storage = moeInput.getStorage();
                            if (storage instanceof JarEntryFile && (parentProject = this.getProjectForJarResource((JarEntryResource)((JarEntryFile)storage))) != null) {
                                return this.searchForClass(parentProject, className);
                            }
                            IPath p = storage.getFullPath();
                            String s0 = p.segment(0);
                            project = ResourcesPlugin.getWorkspace().getRoot().getProject(s0);
                        }
                    } else {
                        project = documentFile.getProject();
                    }
                    if (project != null && project.isOpen()) break block11;
                    return null;
                }
                catch (CoreException x) {
                    ExtensionsPlugin.getPluginLog().logError("Error while looking for class " + className, (Throwable)x);
                    return null;
                }
            }
            if (project.hasNature("org.eclipse.jdt.core.javanature")) break block12;
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return this.searchForClass(javaProject, className);
    }

    private IJavaProject getProjectForJarResource(JarEntryResource jarResource) {
        Object parent = jarResource.getParent();
        while (parent instanceof JarEntryResource) {
            parent = ((JarEntryResource)parent).getParent();
        }
        while (parent instanceof PackageFragment) {
            parent = ((PackageFragment)parent).getParent();
        }
        if (parent instanceof JarPackageFragmentRoot && ((JarPackageFragmentRoot)parent).getParent() instanceof IJavaProject) {
            return (IJavaProject)((JarPackageFragmentRoot)parent).getParent();
        }
        return null;
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    public IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, offset);
            if (n == null || !(n instanceof Text) && !(n instanceof Attr)) {
                return null;
            }
            String text = null;
            int bStart = 0;
            int bEnd = 0;
            if (n instanceof Text) {
                int start = Utils.getValueStart(n);
                int end = Utils.getValueEnd(n);
                if (start < 0 || start > offset) {
                    return null;
                }
                text = this.getDocument().get(start, end - start);
                bStart = offset - start;
                bEnd = offset - start;
            } else if (n instanceof Attr) {
                IDOMAttr attr = (IDOMAttr)n;
                int start = Utils.getValueStart(n);
                if (start < 0) {
                    return null;
                }
                text = this.getDocument().get(start, attr.getValueRegionText().length());
                bStart = offset - start;
                bEnd = offset - start;
            }
            StringBuffer sb = new StringBuffer(text);
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart)) && sb.charAt(bStart) != '.' && sb.charAt(bStart) != '_') {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            while (bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd)) && sb.charAt(bEnd) != '.' && sb.charAt(bEnd) != '_') break;
                ++bEnd;
            }
            int propStart = bStart + Utils.getValueStart(n);
            int propLength = bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String className = this.getClassName(this.fLastRegion);
        if (className == null) {
            return MessageFormat.format(Messages.OpenA, Messages.Class);
        }
        return MessageFormat.format(Messages.OpenClass, className);
    }
}

