/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class ClassMethodHyperlink
extends AbstractHyperlink {
    protected IRegion fLastRegion = null;

    protected abstract String getMethodName(IRegion var1);

    protected abstract String getClassName(IRegion var1);

    protected void doHyperlink(IRegion region) {
        try {
            String className = this.getClassName(region);
            String methodName = this.getMethodName(region);
            IJavaElement classMethod = null;
            if (className != null && className.trim().length() > 0) {
                classMethod = this.searchForClassMethod(className, methodName);
            }
            if (classMethod != null) {
                IEditorPart part = JavaUI.openInEditor(classMethod);
                if (part != null) {
                    JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)classMethod);
                } else {
                    this.openFileFailed();
                }
            } else {
                this.openFileFailed();
            }
        }
        catch (CoreException coreException) {
            this.openFileFailed();
        }
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    private IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart(n);
            int end = Utils.getValueEnd(n);
            if (start < 0 || start > offset || end < offset) {
                return null;
            }
            String text = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = 0;
            int bEnd = text.length() - 1;
            while (bStart < bEnd && (Character.isWhitespace(sb.charAt(bStart)) || sb.charAt(bStart) == '\"' || sb.charAt(bStart) == '\"')) {
                ++bStart;
            }
            while (bEnd > bStart && (Character.isWhitespace(sb.charAt(bEnd)) || sb.charAt(bEnd) == '\"' || sb.charAt(bEnd) == '\"')) {
                --bEnd;
            }
            int propStart = bStart + start;
            int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(propStart, propLength);
            return hyperlinkRegion;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    protected IJavaElement searchForClassMethod(IJavaProject javaProject, String className, String methodName) {
        SearchPattern pattern = SearchPattern.createPattern((String)(String.valueOf(className) + "." + methodName), (int)1, (int)0, (int)8);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        final ArrayList matches = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                matches.add(match);
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        try {
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        }
        catch (CoreException coreException) {}
        Iterator i = matches.iterator();
        if (i != null && i.hasNext()) {
            return (IJavaElement)((SearchMatch)i.next()).getElement();
        }
        return null;
    }

    protected IJavaElement searchForClassMethod(String className, String methodName) {
        IProject project;
        block8: {
            block7: {
                IFile documentFile = this.getFile();
                try {
                    project = null;
                    if (documentFile == null) {
                        IWorkbenchPage workbenchPage = ExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IEditorPart activeEditorPart = workbenchPage.getActiveEditor();
                        IEditorInput editorInput = activeEditorPart.getEditorInput();
                        if (editorInput instanceof IStorageEditorInput) {
                            IStorageEditorInput moeInput = (IStorageEditorInput)editorInput;
                            IPath p = moeInput.getStorage().getFullPath();
                            String s0 = p.segment(0);
                            project = ResourcesPlugin.getWorkspace().getRoot().getProject(s0);
                        }
                    } else {
                        project = documentFile.getProject();
                    }
                    if (project != null && project.isOpen()) break block7;
                    return null;
                }
                catch (CoreException x) {
                    ExtensionsPlugin.getPluginLog().logError("Error while looking for method " + methodName + " of class " + className, (Throwable)x);
                    return null;
                }
            }
            if (project.hasNature("org.eclipse.jdt.core.javanature")) break block8;
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return this.searchForClassMethod(javaProject, className, methodName);
    }

    protected String getAttributeValue(Node node, String attrName) {
        try {
            Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
            return Utils.getTrimmedValue(this.getDocument(), attr);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected String getAttributeValue(IRegion region, String attrName) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            Element node = ((Attr)n).getOwnerElement();
            Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
            String string = Utils.getTrimmedValue(this.getDocument(), attr);
            return string;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }
}

