/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class LinkHyperlink
extends AbstractHyperlink {
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        String fileName = this.getFilePath(region);
        IFile fileToOpen = this.getFileFromProject(fileName);
        if (fileToOpen != null && fileToOpen.exists()) {
            IWorkbenchPage workbenchPage = ExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)fileToOpen, (boolean)true);
            }
            catch (CoreException coreException) {
                this.openFileFailed();
            }
            return;
        }
        try {
            URL url = new URL(fileName);
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
            browser.openURL(url);
        }
        catch (MalformedURLException malformedURLException) {
            this.openFileFailed();
        }
        catch (PartInitException partInitException) {
            this.openFileFailed();
        }
    }

    protected String getFilePath(IRegion region) {
        try {
            return this.getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected String updateFilenameForModel(String filename, IProject project) {
        return filename;
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    protected IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart(n);
            int end = Utils.getValueEnd(n);
            if (start > offset || end < offset) {
                return null;
            }
            String text = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = offset - start;
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart)) && sb.charAt(bStart) != '\\' && sb.charAt(bStart) != '/' && sb.charAt(bStart) != ':' && sb.charAt(bStart) != '-' && sb.charAt(bStart) != '.' && sb.charAt(bStart) != '_' && sb.charAt(bStart) != '%' && sb.charAt(bStart) != '?' && sb.charAt(bStart) != '&' && sb.charAt(bStart) != '=') {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            int bEnd = offset - start;
            while (bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd)) && sb.charAt(bEnd) != '\\' && sb.charAt(bEnd) != '/' && sb.charAt(bEnd) != ':' && sb.charAt(bEnd) != '-' && sb.charAt(bEnd) != '.' && sb.charAt(bEnd) != '_' && sb.charAt(bEnd) != '%' && sb.charAt(bEnd) != '?' && sb.charAt(bEnd) != '&' && sb.charAt(bEnd) != '=') break;
                ++bEnd;
            }
            int propStart = bStart + start;
            int propLength = bEnd - bStart;
            if (propStart > offset + 1 || propStart + propLength < offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(propStart, propLength);
            return hyperlinkRegion;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String filePath = this.getFilePath(this.fLastRegion);
        if (filePath == null) {
            return MessageFormat.format(Messages.OpenA, Messages.File);
        }
        return MessageFormat.format(Messages.OpenFile, filePath);
    }
}

