/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PortletHyperlinkPartitioner
extends AbstractHyperlinkPartitioner {
    public static final String PORTLET_CLASS_PARTITION = "org.jboss.tools.common.text.ext.hyperlink.xml.PORTLET_CLASS";
    public static final String PORTLET_RESOURCE_BUNDLE_PARTITION = "org.jboss.tools.common.text.ext.hyperlink.xml.PORTLET_RESOURCE";
    static final String textNodeName = "#text";
    static final String portletNodeName = "portlet";
    static final String portletClassNodeName = "portlet-class";
    static final String portletResourceBundleNodeName = "resource-bundle";

    public static Node getNode(IDocument document, int superOffset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            Node node;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node node2 = node = Utils.findNodeForOffset(xmlDocument, superOffset);
            return node2;
        }
        finally {
            smw.dispose();
        }
    }

    public static String getType(Node node) {
        Node parentNode = node.getParentNode();
        if (parentNode == null) {
            return null;
        }
        Node portletNode = parentNode.getParentNode();
        if (parentNode == null) {
            return null;
        }
        if (node.getNodeName().equalsIgnoreCase(textNodeName) && portletNode.getNodeName().equalsIgnoreCase(portletNodeName)) {
            if (parentNode.getNodeName().equalsIgnoreCase(portletClassNodeName)) {
                return PORTLET_CLASS_PARTITION;
            }
            if (parentNode.getNodeName().equalsIgnoreCase(portletResourceBundleNodeName)) {
                return PORTLET_RESOURCE_BUNDLE_PARTITION;
            }
        }
        return null;
    }

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        Node node = PortletHyperlinkPartitioner.getNode(document, superRegion.getOffset());
        String type = PortletHyperlinkPartitioner.getType(node);
        if (type == null) {
            return null;
        }
        IndexedRegion text = (IndexedRegion)node;
        int length = text.getLength();
        int offset = text.getStartOffset();
        String contentType = superRegion.getContentType();
        String axis = this.getAxis(document, superRegion);
        HyperlinkRegion hyperRegion = new HyperlinkRegion(offset, length, axis, contentType, type);
        return hyperRegion;
    }
}

