/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class XMLDoctypeHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String XML_DOCTYPE_PARTITION = "org.jboss.tools.common.text.ext.xml.XML_DOCTYPE";

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, superRegion.getOffset());
            if (!(n instanceof DocumentType)) {
                return null;
            }
            int start = Utils.getValueStart(n);
            int end = Utils.getValueEnd(n);
            if (end < 0) {
                return null;
            }
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = XML_DOCTYPE_PARTITION;
            int length = end - start - (superRegion.getOffset() - start);
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAxis(IDocument document, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node node = Utils.findNodeForOffset(xmlDocument, superRegion.getOffset());
            if (node instanceof DocumentType) {
                String string = "/@DOCTYPE/" + node.getNodeName() + "/";
                return string;
            }
            String string = Utils.getParentAxisForNode(xmlDocument, node);
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, region.getOffset());
            return n instanceof DocumentType;
            {
            }
        }
        finally {
            smw.dispose();
        }
    }
}

