/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLElementNameHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String XML_ELEMENT_NAME_PARTITION = "org.jboss.tools.common.text.ext.xml.XML_ELEMENT_NAME";

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, superRegion.getOffset());
            if (n == null || !(n instanceof IDOMElement)) {
                return null;
            }
            IHyperlinkRegion r = XMLElementNameHyperlinkPartitioner.getRegion(document, superRegion.getOffset());
            if (r == null) {
                return null;
            }
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = XML_ELEMENT_NAME_PARTITION;
            int length = r.getLength() - (superRegion.getOffset() - r.getOffset());
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    public static IHyperlinkRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, offset);
            if (n == null || !(n instanceof IDOMElement)) {
                return null;
            }
            IDOMElement elem = (IDOMElement)n;
            String tagName = elem.getTagName();
            int start = elem.getStartOffset();
            int nameStart = start + (elem.isEndTag() ? "</" : "<").length();
            int nameEnd = nameStart + tagName.length();
            if (nameStart > offset || nameEnd <= offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(nameStart, nameEnd - nameStart, null, null, null);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, region.getOffset());
            if (!(n instanceof IDOMElement)) {
                return false;
            }
            IDOMElement elem = (IDOMElement)n;
            String tagName = elem.getTagName();
            int start = elem.getStartOffset();
            int nameStart = start + (elem.isEndTag() ? "<" : "</").length();
            int nameEnd = nameStart + tagName.length();
            boolean bl = region.getOffset() > nameStart && region.getOffset() <= nameEnd;
            return bl;
        }
        finally {
            smw.dispose();
        }
    }
}

