/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLJumpToHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String XML_JUMP_TO_PARTITION = "org.jboss.tools.common.text.xml.XML_JUMP_TO";

    protected String getPartitionType() {
        return XML_JUMP_TO_PARTITION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Utils.findNodeForOffset(xmlDocument, superRegion.getOffset());
            if (!this.recognize(document, superRegion)) {
                return null;
            }
            IRegion r = this.getRegion(document, superRegion.getOffset());
            if (r == null) {
                return null;
            }
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = this.getPartitionType();
            int length = r.getLength() - (superRegion.getOffset() - r.getOffset());
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    protected IRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, offset);
            if (n == null || !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart(n);
            int end = Utils.getValueEnd(n);
            if (start < 0 || start > offset) {
                return null;
            }
            String attrText = document.get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = 0;
            int bEnd = attrText.length() - 1;
            while (bStart < bEnd && (sb.charAt(bStart) == '\'' || sb.charAt(bStart) == '\"' || Character.isWhitespace(sb.charAt(bStart)))) {
                ++bStart;
            }
            while (bEnd > bStart && (sb.charAt(bEnd) == '\'' || sb.charAt(bEnd) == '\"' || Character.isWhitespace(sb.charAt(bEnd)))) {
                --bEnd;
            }
            int propStart = bStart + start;
            int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    protected String[] getValidAxisEndings() {
        return null;
    }

    private boolean validAxis(Node n, String validAxisEnding) {
        if (validAxisEnding == null || validAxisEnding.lastIndexOf(47) == -1) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(validAxisEnding, "/");
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        if (tokens.size() == 0) {
            return false;
        }
        Node currentElement = n;
        int i = tokens.size() - 1;
        while (i >= 0) {
            if (currentElement == null || !(currentElement instanceof Element)) {
                return false;
            }
            String token = (String)tokens.get(i);
            if (!token.equals(currentElement.getNodeName())) {
                return false;
            }
            currentElement = currentElement.getParentNode();
            --i;
        }
        return true;
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, region.getOffset());
            if (!(n instanceof Text)) {
                return false;
            }
            String[] validAxisEndings = this.getValidAxisEndings();
            if (validAxisEndings == null || validAxisEndings.length == 0) {
                return false;
            }
            int i = 0;
            while (validAxisEndings != null && i < validAxisEndings.length) {
                if (this.validAxis(n.getParentNode(), validAxisEndings[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        finally {
            smw.dispose();
        }
    }
}

