/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLRootHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String XML_ROOT_PARTITION = "org.jboss.tools.common.text.ext.xml.XML_ROOT";

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        if (!this.recognize(document, superRegion)) {
            return null;
        }
        String axis = String.valueOf(XMLRootHyperlinkPartitioner.computeAxis(document, superRegion.getOffset())) + "/";
        String contentType = superRegion.getContentType();
        String type = XML_ROOT_PARTITION;
        int length = superRegion.getLength();
        int offset = superRegion.getOffset();
        HyperlinkRegion region = new HyperlinkRegion(offset, length, axis, contentType, type);
        return region;
    }

    public static String computeAxis(IDocument document, int offset) {
        String axis = "";
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, offset);
            HashMap trackersMap = new HashMap();
            if (n != null) {
                if ((n instanceof Element || n instanceof Attr) && n.getNodeName() != null && n.getNodeName().length() > 0) {
                    Element e;
                    String jsfcAttrValue;
                    String name = n.getNodeName();
                    if (n instanceof Element && (jsfcAttrValue = (e = (Element)n).getAttribute("jsfc")) != null && jsfcAttrValue.trim().length() > 0) {
                        name = jsfcAttrValue;
                    }
                    String nodeName = XMLRootHyperlinkPartitioner.extractName(name, trackersMap);
                    axis = "/" + nodeName;
                }
                Node parent = n instanceof Attr ? ((Attr)n).getOwnerElement() : n.getParentNode();
                while (parent instanceof Element) {
                    String nodeName;
                    Element e;
                    String jsfcAttrValue;
                    String name = parent.getNodeName();
                    if (parent instanceof Element && (jsfcAttrValue = (e = (Element)parent).getAttribute("jsfc")) != null && jsfcAttrValue.trim().length() > 0) {
                        name = jsfcAttrValue;
                    }
                    if ((nodeName = XMLRootHyperlinkPartitioner.extractName(name, trackersMap)) != null && nodeName.length() > 0) {
                        axis = "/" + nodeName + axis;
                    }
                    parent = parent.getParentNode();
                }
            }
        }
        finally {
            smw.dispose();
        }
        if (axis == null || axis.length() == 0) {
            axis = "";
        }
        return axis;
    }

    public static String extractName(String name, Map trackersMap) {
        if (trackersMap == null || trackersMap.size() == 0) {
            return name;
        }
        if (name == null) {
            return null;
        }
        int column = name.indexOf(":");
        if (column == -1) {
            return name;
        }
        String prefix = name.substring(0, column);
        if (prefix == null || prefix.trim().length() == 0) {
            return name;
        }
        String uri = (String)trackersMap.get(prefix);
        if (uri == null || uri.length() == 0) {
            return name;
        }
        return "[" + uri + "]" + name.substring(column);
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, region.getOffset());
            boolean bl = n != null;
            return bl;
        }
        finally {
            smw.dispose();
        }
    }
}

