/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLXmlNsHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String XML_XMLNS_PARTITION = "org.jboss.tools.common.text.ext.xml.XML_XMLNS";

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, superRegion.getOffset());
            if (!(n instanceof IDOMAttr)) {
                return null;
            }
            IDOMAttr xmlnsAttr = (IDOMAttr)n;
            if (xmlnsAttr.getName() == null || !xmlnsAttr.getName().startsWith("xmlns:") && !xmlnsAttr.getName().endsWith(":schemaLocation")) {
                return null;
            }
            String xmlns = xmlnsAttr.getValueRegionText();
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = XML_XMLNS_PARTITION;
            int length = xmlns.length() - (superRegion.getOffset() - xmlnsAttr.getValueRegionStartOffset());
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, region.getOffset());
            if (!(n instanceof IDOMAttr)) {
                return false;
            }
            IDOMAttr xmlnsAttr = (IDOMAttr)n;
            if (xmlnsAttr.getName() == null || !xmlnsAttr.getName().equals("xmlns") && !xmlnsAttr.getName().startsWith("xmlns:") && !xmlnsAttr.getName().endsWith(":schemaLocation")) {
                return false;
            }
            Element rootElement = xmlnsAttr.getOwnerElement();
            return rootElement instanceof IDOMElement;
            {
            }
        }
        finally {
            smw.dispose();
        }
    }
}

