/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xpl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkBuilder;
import org.jboss.tools.common.text.ext.hyperlink.xpl.HyperlinkDefinition;
import org.jboss.tools.common.text.ext.util.xpl.RegistryReader;

public class BaseHyperlinkBuilder
extends RegistryReader {
    public static final String PL_HYPERLINK = "hyperlink";
    public static final String TAG_HYPERLINK = "hyperlink";
    public static final String TAG_CONTENT_TYPE_IDENTIFIER = "contenttypeidentifier";
    public static final String TAG_PARTITION_TYPE = "partitiontype";
    public static final String ATT_ID = "id";
    public static final String ATT_CLASS = "class";
    protected String targetContributionTag;
    private static HyperlinkBuilder fInstance;
    private List fHyperlinkDefs = null;
    private HyperlinkDefinition fCurrentHyperlinkDefinition = null;
    private String fCurrentContentType;

    public static synchronized HyperlinkBuilder getInstance() {
        if (fInstance == null) {
            fInstance = new HyperlinkBuilder();
        }
        return fInstance;
    }

    protected String getId(IConfigurationElement element) {
        String value = element.getAttribute(ATT_ID);
        return value;
    }

    protected String getHyperlinkClass(IConfigurationElement element) {
        String value = element.getAttribute(ATT_CLASS);
        return value;
    }

    private void processHyperlinkTag(IConfigurationElement element) {
        String theId = this.getId(element);
        String theClass = this.getHyperlinkClass(element);
        if (theId != null && theClass != null) {
            this.fCurrentHyperlinkDefinition = new HyperlinkDefinition(theId, theClass, element);
            if (this.fHyperlinkDefs == null) {
                this.fHyperlinkDefs = new ArrayList();
            }
            this.fHyperlinkDefs.add(this.fCurrentHyperlinkDefinition);
        } else {
            this.fCurrentHyperlinkDefinition = null;
        }
    }

    private void processContentTypeTag(IConfigurationElement element) {
        String theId = this.getId(element);
        if (theId != null) {
            this.fCurrentContentType = theId;
            this.fCurrentHyperlinkDefinition.addContentTypeId(this.fCurrentContentType);
        } else {
            this.fCurrentContentType = null;
        }
    }

    private void processPartitionTypeTag(IConfigurationElement element) {
        String theId = this.getId(element);
        if (theId != null) {
            this.fCurrentHyperlinkDefinition.addPartitionType(this.fCurrentContentType, theId);
        }
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(this.targetContributionTag)) {
            this.processHyperlinkTag(element);
            if (this.fCurrentHyperlinkDefinition != null) {
                this.readElementChildren(element);
            }
            return true;
        }
        if (tag.equals(TAG_CONTENT_TYPE_IDENTIFIER)) {
            this.processContentTypeTag(element);
            if (this.fCurrentContentType != null) {
                this.readElementChildren(element);
            }
            return true;
        }
        if (tag.equals(TAG_PARTITION_TYPE)) {
            this.processPartitionTypeTag(element);
            return true;
        }
        return false;
    }

    private void initCache() {
        if (this.fHyperlinkDefs == null) {
            this.readContributions("hyperlink", "hyperlink");
        }
    }

    protected void readContributions(String tag_hyperlink2, String pl_hyperlink2) {
    }

    public HyperlinkDefinition[] getHyperlinkDefinitions() {
        this.initCache();
        return this.fHyperlinkDefs == null ? new HyperlinkDefinition[]{} : this.fHyperlinkDefs.toArray(new HyperlinkDefinition[this.fHyperlinkDefs.size()]);
    }

    public HyperlinkDefinition[] getHyperlinkDefinitions(String contentType, String partitionType) {
        if (contentType == null || partitionType == null) {
            return null;
        }
        HyperlinkDefinition[] allDefs = this.getHyperlinkDefinitions();
        ArrayList<HyperlinkDefinition> defs = new ArrayList<HyperlinkDefinition>();
        ArrayList<HyperlinkDefinition> lastDefs = new ArrayList<HyperlinkDefinition>();
        int i = 0;
        while (i < allDefs.length) {
            List partitions = (List)allDefs[i].getContentTypes().get(contentType);
            if (partitions != null) {
                if (partitions.isEmpty()) {
                    lastDefs.add(allDefs[i]);
                } else {
                    int j = 0;
                    boolean added = false;
                    while (j < partitions.size() && !added) {
                        if (partitionType.equals(partitions.get(j))) {
                            defs.add(allDefs[i]);
                            added = true;
                            continue;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        defs.addAll(lastDefs);
        return defs.toArray(new HyperlinkDefinition[defs.size()]);
    }
}

