/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xpl;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkBuilder;
import org.jboss.tools.common.text.ext.hyperlink.xpl.HyperlinkDefinition;

public class BaseHyperlinkDetector
implements IHyperlinkDetector {
    public IHyperlink[] getHyperlinks(ITextViewer textViewer, IRegion region) {
        IHyperlink[] hyperlinks = null;
        if (textViewer != null && textViewer.getDocument() != null) {
            String contentType = this.getContentType(textViewer.getDocument());
            String partitionType = this.getPartitionType(textViewer.getDocument(), region.getOffset());
            hyperlinks = this.getHyperlinks(textViewer, region, contentType, partitionType);
        }
        return hyperlinks;
    }

    public IHyperlink[] getHyperlinks(ITextViewer textViewer, IRegion region, String contentType, String partitionType) {
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>();
        if (textViewer != null && textViewer.getDocument() != null) {
            HyperlinkDefinition[] defs = HyperlinkBuilder.getInstance().getHyperlinkDefinitions(contentType, partitionType);
            if (defs == null) {
                return null;
            }
            int i = 0;
            while (i < defs.length) {
                IHyperlink hyperlink = defs[i].createHyperlink();
                if (!hyperlinks.contains(hyperlink)) {
                    if (hyperlink instanceof AbstractHyperlink) {
                        ((AbstractHyperlink)hyperlink).setDocument(textViewer.getDocument());
                        ((AbstractHyperlink)hyperlink).setOffset(region.getOffset());
                    }
                    hyperlinks.add(hyperlink);
                }
                ++i;
            }
        }
        return hyperlinks.size() == 0 ? null : hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    protected String getContentType(IDocument document) {
        String type = null;
        IModelManager mgr = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = mgr.getExistingModelForRead(document);
            if (model != null) {
                type = model.getContentTypeIdentifier();
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return type;
    }

    protected String getPartitionType(IDocument document, int offset) {
        String type = null;
        String[] types = this.getPartitionTypes(document, offset);
        if (types != null && types.length > 0) {
            type = types[0];
        }
        return type;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] hyperlinks = this.getHyperlinks(textViewer, region);
        if (hyperlinks != null && hyperlinks.length > 0 && !canShowMultipleHyperlinks) {
            hyperlinks = new IHyperlink[]{hyperlinks[0]};
        }
        return hyperlinks;
    }

    protected String[] getPartitionTypes(IDocument document, int offset) {
        return new String[0];
    }
}

