/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.resref.core;

import java.util.Map;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.vpe.resref.Activator;
import org.jboss.tools.vpe.resref.core.Messages;
import org.jboss.tools.vpe.resref.core.ResourceReferenceValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELResourceReferenceValidator
extends ResourceReferenceValidator {
    public static final String EL_NAME = "elName";
    private ResourceReference resref = null;
    private ResourceReference[] resrefList = null;

    public ELResourceReferenceValidator() {
    }

    public ELResourceReferenceValidator(Map<String, String> fields, ResourceReference resref, ResourceReference[] resrefList) {
        super(fields);
        this.resref = resref;
        this.resrefList = resrefList;
    }

    public void setResref(ResourceReference resref) {
        this.resref = resref;
    }

    public void setResrefList(ResourceReference[] resrefList) {
        this.resrefList = resrefList;
    }

    @Override
    protected boolean validate() {
        this.errorMessage = null;
        this.pageComplete = true;
        if (this.fields != null) {
            String elName = (String)this.fields.get(EL_NAME);
            if (elName != null && elName.length() > 0) {
                ELParser elParser = ELParserUtil.getDefaultFactory().createParser();
                ELModel model = elParser.parse("#{" + elName + "}");
                if (model == null || model.getSyntaxErrors().size() > 0) {
                    this.errorMessage = Messages.INVALID_EL_EXPRESSION;
                    this.pageComplete = false;
                } else {
                    String scope = (String)this.fields.get("scope");
                    int selectedScope = -1;
                    try {
                        selectedScope = Integer.parseInt(scope);
                    }
                    catch (NumberFormatException e) {
                        Activator.getDefault().logError(Messages.CANNOT_PARSE_SCOPE_VALUE, e);
                    }
                    if (selectedScope != -1) {
                        ResourceReference[] resourceReferenceArray = this.resrefList;
                        int n = this.resrefList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ResourceReference listItemReference = resourceReferenceArray[n2];
                            if (this.resref != listItemReference && listItemReference.getScope() == selectedScope && elName.equals(listItemReference.getLocation())) {
                                this.errorMessage = Messages.EL_EXPRESSION_ALREADY_EXISTS;
                                this.pageComplete = false;
                                break;
                            }
                            ++n2;
                        }
                    }
                }
            } else {
                this.errorMessage = Messages.EL_NAME_SHOULD_BE_SET;
                this.pageComplete = false;
            }
        }
        return this.pageComplete;
    }
}

