/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.resref.core;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.common.resref.core.ResourceReferenceList;
import org.jboss.tools.vpe.resref.core.Messages;

public abstract class FolderReferenceComposite
implements ModifyListener {
    private final String BROWSE_BUTTON_NAME = "&Browse...";
    private Text text = null;
    Object fileLocation = null;
    ResourceReference[] rs = null;
    ResourceReference current = null;
    private String browseDialogFilterPath = null;

    public void setObject(Object fileLocation) {
        this.fileLocation = fileLocation;
        if (fileLocation instanceof IFile) {
            this.browseDialogFilterPath = ((IFile)fileLocation).getProject().getLocation().toString();
        }
        if (fileLocation != null) {
            if (fileLocation instanceof IFile) {
                this.rs = this.getReferenceList().getAllResources((IFile)fileLocation);
            } else if (fileLocation instanceof IPath) {
                this.rs = this.getReferenceList().getAllResources((IPath)fileLocation);
            }
        } else {
            this.rs = new ResourceReference[0];
        }
        if (this.rs.length == 0) {
            this.rs = new ResourceReference[1];
            this.rs[0] = new ResourceReference("", 0);
        }
        this.current = this.rs[0];
    }

    protected abstract ResourceReferenceList getReferenceList();

    protected abstract String getTitle();

    public Control createControl(Composite parent) {
        Group groupControl = new Group(parent, 16);
        GridData gd = new GridData(4, 4, true, true);
        GridLayout layout = new GridLayout(3, false);
        groupControl.setLayout((Layout)layout);
        groupControl.setLayoutData((Object)gd);
        groupControl.setText(this.getTitle());
        Label pathLabel = new Label((Composite)groupControl, 131072);
        pathLabel.setText(Messages.FOLDER_PATH);
        gd = new GridData();
        pathLabel.setLayoutData((Object)gd);
        this.text = new Text((Composite)groupControl, 2048);
        this.text.setText(this.current.getLocation());
        gd = new GridData(4, 0, true, false);
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener((ModifyListener)this);
        final Button button = new Button((Composite)groupControl, 8);
        button.setText("&Browse...");
        gd = new GridData();
        button.setLayoutData((Object)gd);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String newPath;
                DirectoryDialog dialog = new DirectoryDialog(button.getShell());
                dialog.setMessage(Messages.SELECT_FOLDER_DIALOG_TITLE);
                if (FolderReferenceComposite.this.browseDialogFilterPath != null && new File(FolderReferenceComposite.this.browseDialogFilterPath).exists()) {
                    dialog.setFilterPath(FolderReferenceComposite.this.browseDialogFilterPath);
                }
                if ((newPath = dialog.open()) != null) {
                    newPath = newPath.trim();
                    FolderReferenceComposite.this.browseDialogFilterPath = newPath;
                    FolderReferenceComposite.this.current.setLocation(newPath);
                    FolderReferenceComposite.this.text.setText(newPath);
                }
            }
        });
        Label comboboxLabel = new Label((Composite)groupControl, 131072);
        comboboxLabel.setText(Messages.SCOPE_GROUP_NAME);
        gd = new GridData();
        comboboxLabel.setLayoutData((Object)gd);
        final Combo scopeCombo = new Combo((Composite)groupControl, 2056);
        String[] items = new String[]{Messages.SCOPE_PAGE_SHORT, Messages.SCOPE_FOLDER_SHORT, Messages.SCOPE_PROJECT_SHORT};
        scopeCombo.setItems(items);
        scopeCombo.select(this.current.getScope());
        gd = new GridData(4, 0, true, false, 2, 1);
        scopeCombo.setLayoutData((Object)gd);
        scopeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderReferenceComposite.this.current.setScope(scopeCombo.getSelectionIndex());
            }
        });
        return groupControl;
    }

    public void commit() {
        ArrayList<ResourceReference> l = new ArrayList<ResourceReference>();
        int i = this.rs.length - 2;
        while (i >= 0) {
            if (!this.rs[i].getLocation().equals(this.current.getLocation()) && this.rs[i].getScope() != this.current.getScope()) {
                l.add(this.rs[i]);
            }
            --i;
        }
        l.add(this.current);
        this.rs = l.toArray(new ResourceReference[0]);
        if (this.fileLocation != null) {
            if (this.fileLocation instanceof IFile) {
                this.getReferenceList().setAllResources((IFile)this.fileLocation, this.rs);
            } else if (this.fileLocation instanceof IPath) {
                this.getReferenceList().setAllResources((IPath)this.fileLocation, this.rs);
            }
        }
    }

    public void setFileLocation(Object fileLocation) {
        this.fileLocation = fileLocation;
    }

    public void modifyText(ModifyEvent e) {
        this.browseDialogFilterPath = this.text.getText().trim();
        this.current.setLocation(this.browseDialogFilterPath);
    }
}

