/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.resref.core;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.vpe.resref.Activator;
import org.jboss.tools.vpe.resref.core.Messages;
import org.jboss.tools.vpe.resref.core.ResourceReferenceValidator;
import org.osgi.framework.Bundle;

public abstract class ReferenceWizardPage
extends WizardPage
implements SelectionListener,
Listener {
    protected final String BROWSE_BUTTON_NAME = "&Browse...";
    protected ResourceReference resref = null;
    protected Object fileLocation = null;
    protected ResourceReferenceValidator validator = null;
    private static final String PAGE_TITLE_IMAGE_PATH = "/images/xstudio/wizards/EclipseDefault.png";
    private Button pageRadioButton;
    private Button folderRadioButton;
    private Button projectRadioButton;
    private int scope = 1;

    public ReferenceWizardPage(String pageName, String title, ImageDescriptor titleImage, Object fileLocation) {
        super(pageName, title, titleImage);
        this.fileLocation = fileLocation;
        this.setPageComplete(false);
    }

    public static ImageDescriptor getImageDescriptor() {
        Bundle bundle = Platform.getBundle((String)"org.jboss.tools.common.model.ui");
        URL url = null;
        ImageDescriptor image = null;
        if (bundle != null) {
            try {
                url = FileLocator.resolve((URL)bundle.getEntry(PAGE_TITLE_IMAGE_PATH));
            }
            catch (IOException e) {
                Activator.getDefault().logError(NLS.bind((String)Messages.VRD_TITLE_IMAGE_CANNOT_BE_RESOLVED, (Object)url), e);
            }
        }
        if (url != null) {
            image = ImageDescriptor.createFromURL(url);
        }
        return image;
    }

    protected Group createScopeGroup(Composite parent) {
        Group groupControl = new Group(parent, 16);
        groupControl.setText(Messages.SCOPE_GROUP_NAME);
        GridLayout layout = new GridLayout(1, false);
        groupControl.setLayout((Layout)layout);
        this.pageRadioButton = new Button((Composite)groupControl, 16);
        this.pageRadioButton.setText(Messages.SCOPE_PAGE);
        this.pageRadioButton.addSelectionListener((SelectionListener)this);
        this.folderRadioButton = new Button((Composite)groupControl, 16);
        this.folderRadioButton.setText(Messages.SCOPE_FOLDER);
        this.folderRadioButton.addSelectionListener((SelectionListener)this);
        this.projectRadioButton = new Button((Composite)groupControl, 16);
        this.projectRadioButton.setText(Messages.SCOPE_PROJECT);
        this.projectRadioButton.addSelectionListener((SelectionListener)this);
        this.setScopeRadioButtonSelection();
        return groupControl;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.validatePage();
    }

    public void handleEvent(Event event) {
        this.validatePage();
    }

    protected int getSelectedScope() {
        int scope = 0;
        if (this.pageRadioButton != null && this.pageRadioButton.getSelection()) {
            scope = 0;
        } else if (this.folderRadioButton != null && this.folderRadioButton.getSelection()) {
            scope = 1;
        } else if (this.projectRadioButton != null && this.projectRadioButton.getSelection()) {
            scope = 2;
        }
        return scope;
    }

    protected void setScope(int scope) {
        this.scope = scope;
    }

    private void setScopeRadioButtonSelection() {
        switch (this.scope) {
            case 0: {
                this.pageRadioButton.setSelection(true);
                break;
            }
            case 1: {
                this.folderRadioButton.setSelection(true);
                break;
            }
            case 2: {
                this.projectRadioButton.setSelection(true);
                break;
            }
            default: {
                this.folderRadioButton.setSelection(true);
            }
        }
    }

    protected void validatePage() {
        this.validator = this.getUpdatedValidator();
        this.setPageComplete(this.validator.validate());
        this.setErrorMessage(this.validator.getErrorMessage());
    }

    public ResourceReference getResref() {
        return this.resref;
    }

    public void setResref(ResourceReference resref) {
        this.resref = resref;
    }

    protected abstract String getLocation();

    protected abstract String getProperties();

    protected abstract void setLocation(String var1);

    protected abstract void setProperties(String var1);

    protected abstract ResourceReferenceValidator getUpdatedValidator();
}

