/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.verification.vrules;

import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.log.LogHelper;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintQClassName;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VResult;
import org.jboss.tools.common.verification.vrules.layer.VObjectImpl;
import org.jboss.tools.jst.web.verification.vrules.WebDefaultCheck;

public class CheckClass
extends WebDefaultCheck {
    XAttributeConstraintQClassName constraint = new XAttributeConstraintQClassName();

    public VResult[] check(VObject object) {
        XModelObject o = ((VObjectImpl)object).getModelObject();
        String attr = this.getAttribute();
        if (attr == null) {
            return null;
        }
        String value = o.getAttributeValue(attr);
        if (value.length() == 0 || this.isJavaLang(value)) {
            return null;
        }
        if (this.isPrimitive(value)) {
            return this.allowsPrimitive() ? null : this.fire(object, attr, attr, value);
        }
        if (!this.checkQualifiedName(value)) {
            return this.fireInvalid(object, attr, attr, value);
        }
        IType type = object.getModel().getValidType(value);
        if (type != null) {
            String mustImpl = null;
            try {
                mustImpl = this.checkImplements(object, type);
            }
            catch (Exception e) {
                LogHelper.logError((String)"org.jboss.tools.jst.web.verification", (Throwable)e);
            }
            if (mustImpl != null) {
                return this.fireImplements(object, attr, attr, value, mustImpl);
            }
            String mustExtend = null;
            try {
                mustExtend = this.checkExtends(object, type);
            }
            catch (Exception e) {
                LogHelper.logError((String)"org.jboss.tools.jst.web.verification", (Throwable)e);
            }
            if (mustExtend != null) {
                return this.fireExtends(object, attr, attr, value, mustExtend);
            }
            return null;
        }
        return this.fire(object, attr, attr, value);
    }

    private boolean checkQualifiedName(String value) {
        return this.constraint.accepts(value);
    }

    private String checkImplements(VObject object, IType type) throws Exception {
        if ("java.lang.Class".equals(type.getFullyQualifiedName())) {
            return null;
        }
        String impl = this.rule.getProperty("implements");
        if (impl == null || impl.length() == 0) {
            return null;
        }
        String[] is = type.getSuperInterfaceNames();
        int i = 0;
        while (i < is.length) {
            String f = EclipseJavaUtil.resolveType((IType)type, (String)is[i]);
            if (f != null && f.equals(impl)) {
                return null;
            }
            ++i;
        }
        if (type.isInterface()) {
            return impl;
        }
        String f = type.getSuperclassName();
        if (f == null || f.length() == 0 || "java.lang.Object".equals(f)) {
            return impl;
        }
        if ((f = EclipseJavaUtil.resolveType((IType)type, (String)f)) == null || f.length() == 0 || "java.lang.Object".equals(f)) {
            return impl;
        }
        type = object.getModel().getValidType(f);
        if (type == null) {
            return impl;
        }
        return this.checkImplements(object, type);
    }

    private String checkExtends(VObject object, IType type) throws Exception {
        if (type.isInterface()) {
            return null;
        }
        if ("java.lang.Class".equals(type.getFullyQualifiedName())) {
            return null;
        }
        String ext = this.rule.getProperty("extends");
        if (ext == null || ext.length() == 0) {
            return null;
        }
        String f = type.getSuperclassName();
        if (f == null || f.length() == 0 || "java.lang.Object".equals(f)) {
            return ext;
        }
        if (f.equals(ext)) {
            return null;
        }
        if ((f = EclipseJavaUtil.resolveType((IType)type, (String)f)) == null || f.length() == 0 || "java.lang.Object".equals(f)) {
            return ext;
        }
        if (f.equals(ext)) {
            return null;
        }
        type = object.getModel().getValidType(f);
        if (type == null) {
            return ext;
        }
        return this.checkExtends(object, type);
    }

    protected String getAttribute() {
        return this.rule.getProperty("attribute");
    }

    private boolean allowsPrimitive() {
        return "true".equals(this.rule.getProperty("allow-primitive"));
    }

    private boolean isPrimitive(String value) {
        return ".int.boolean.char.byte.double.float.long.short.".indexOf("." + value + ".") >= 0;
    }

    private boolean isJavaLang(String value) {
        if (value.indexOf(46) < 0) {
            return ".String.Integer.Boolean.Character.Byte.Double.Float.Long.Short.".indexOf("." + value + ".") >= 0;
        }
        if (value.startsWith("java.lang.")) {
            return this.isJavaLang(value.substring(10));
        }
        return false;
    }

    protected VResult[] fire(VObject object, String id, String attr, String value) {
        Object[] os = new Object[]{attr, value};
        VResult result = this.rule.getResultFactory().getResult(id, object, (Object)attr, object, (Object)attr, os);
        return new VResult[]{result};
    }

    protected VResult[] fireImplements(VObject object, String id, String attr, String value, String interfaceName) {
        Object[] os = new Object[]{attr, value, interfaceName};
        VResult result = this.rule.getResultFactory().getResult(String.valueOf(id) + ".implements", object, (Object)attr, object, (Object)attr, os);
        return new VResult[]{result};
    }

    protected VResult[] fireExtends(VObject object, String id, String attr, String value, String superName) {
        Object[] os = new Object[]{attr, value, superName};
        VResult result = this.rule.getResultFactory().getResult(String.valueOf(id) + ".extends", object, (Object)attr, object, (Object)attr, os);
        return new VResult[]{result};
    }

    protected VResult[] fireInvalid(VObject object, String id, String attr, String value) {
        Object[] os = new Object[]{attr, value};
        VResult result = this.rule.getResultFactory().getResult(String.valueOf(id) + ".valid", object, (Object)attr, object, (Object)attr, os);
        return new VResult[]{result};
    }
}

