/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.text.ext.hyperlink;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.text.ext.hyperlink.RelativeLinkHyperlink;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class JSPStylesheetRelLinkHyperlink
extends RelativeLinkHyperlink {
    private static final String HREF_ATTRNAME = "href";

    protected IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Text) && !(n instanceof Attr)) {
                return null;
            }
            String text = null;
            int bStart = 0;
            int bEnd = 0;
            if (n instanceof Text) {
                int start = Utils.getValueStart((Node)n);
                int end = Utils.getValueEnd((Node)n);
                if (start < 0 || start > offset) {
                    return null;
                }
                text = this.getDocument().get(start, end - start);
                bStart = offset - start;
                bEnd = offset - start;
            } else if (n instanceof Attr) {
                Attr attr = (Attr)n;
                if (!HREF_ATTRNAME.equalsIgnoreCase(attr.getName())) {
                    return null;
                }
                int start = Utils.getValueStart((Node)n);
                int end = Utils.getValueEnd((Node)n);
                if (start < 0) {
                    return null;
                }
                text = this.getDocument().get(start, end - start);
                bStart = offset - start;
                bEnd = offset - start;
            }
            StringBuffer sb = new StringBuffer(text);
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart)) && sb.charAt(bStart) != '\\' && sb.charAt(bStart) != '/' && sb.charAt(bStart) != ':' && sb.charAt(bStart) != '-' && sb.charAt(bStart) != '.' && sb.charAt(bStart) != '_' && sb.charAt(bStart) != '%' && sb.charAt(bStart) != '?' && sb.charAt(bStart) != '&' && sb.charAt(bStart) != '=') {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            while (bEnd >= 0 && bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd)) && sb.charAt(bEnd) != '\\' && sb.charAt(bEnd) != '/' && sb.charAt(bEnd) != ':' && sb.charAt(bEnd) != '-' && sb.charAt(bEnd) != '.' && sb.charAt(bEnd) != '_' && sb.charAt(bEnd) != '%' && sb.charAt(bEnd) != '?' && sb.charAt(bEnd) != '&' && sb.charAt(bEnd) != '=') break;
                ++bEnd;
            }
            int propStart = bStart + Utils.getValueStart((Node)n);
            int propLength = bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }
}

