/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.text.ext.hyperlink.jsp;

import java.text.MessageFormat;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPElementNameHyperlinkPartitioner;
import org.jboss.tools.jst.text.ext.util.TaglibManagerWrapper;
import org.jboss.tools.jst.web.tld.ITaglibMapping;
import org.jboss.tools.jst.web.tld.IWebProject;
import org.jboss.tools.jst.web.tld.WebProjectFactory;
import org.w3c.dom.Document;

public class JSPElementNameHyperlink
extends AbstractHyperlink {
    protected final String JAR_FILE_PROTOCOL = "jar:file:/";
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        XModelObject object = this.getFilename(region);
        if (object != null) {
            FindObjectHelper.findModelObject((XModelObject)object, (int)FindObjectHelper.IN_EDITOR_ONLY);
        } else {
            this.openFileFailed();
        }
    }

    protected void openFileInEditor(String fileString) {
        if (fileString.startsWith("jar:file:/")) {
            IEditorInput jarEditorInput = this.createEditorInput(fileString = fileString.substring("jar:file:/".length()));
            IEditorPart part = this.openFileInEditor(jarEditorInput, fileString);
            if (part == null) {
                this.openFileFailed();
            }
        } else {
            super.openFileInEditor(fileString);
        }
    }

    private XModelObject getFilename(IRegion region) {
        XModel xModel = this.getXModel();
        if (xModel == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            String nodePrefix = this.getTagPrefix(region);
            if (nodePrefix == null) {
                return null;
            }
            TaglibManagerWrapper tmw = new TaglibManagerWrapper();
            tmw.init(this.getDocument(), region.getOffset());
            if (!tmw.exists()) {
                return null;
            }
            String uri = tmw.getUri(nodePrefix);
            if (uri == null) {
                return null;
            }
            IWebProject wp = WebProjectFactory.instance.getWebProject(xModel);
            if (wp == null) {
                return null;
            }
            ITaglibMapping tm = wp.getTaglibMapping();
            if (tm == null) {
                return null;
            }
            tm.invalidate();
            XModelObject xModelObject = tm.getTaglibObject(uri);
            return xModelObject;
        }
        finally {
            smw.dispose();
        }
    }

    private String getTagPrefix(IRegion region) {
        String nodePrefix;
        String nodeName;
        if (region == null) {
            return null;
        }
        try {
            nodeName = this.getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (nodeName.indexOf(":") != -1 && (nodePrefix = nodeName.substring(0, nodeName.indexOf(":"))) != null && nodePrefix.length() > 0) {
            return nodePrefix;
        }
        return null;
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = JSPElementNameHyperlinkPartitioner.getRegion((IDocument)this.getDocument(), (int)offset);
        return this.fLastRegion;
    }

    public String getHyperlinkText() {
        String tagPrefix = this.getTagPrefix(this.fLastRegion);
        if (tagPrefix == null) {
            return MessageFormat.format(Messages.OpenA, Messages.TagLibrary);
        }
        return MessageFormat.format(Messages.OpenTagLibraryForPrefix, tagPrefix);
    }
}

