/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.text.ext.hyperlink.jsp;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.tld.ITaglibMapping;
import org.jboss.tools.jst.web.tld.IWebProject;
import org.jboss.tools.jst.web.tld.WebProjectFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JSPTaglibHyperlink
extends AbstractHyperlink {
    protected final String JAR_FILE_PROTOCOL = "jar:file:/";
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        XModelObject object = this.getFilename(region);
        if (object != null) {
            FindObjectHelper.findModelObject((XModelObject)object, (int)FindObjectHelper.IN_EDITOR_ONLY);
        } else {
            this.openFileFailed();
        }
    }

    protected void openFileInEditor(String fileString) {
        if (fileString.startsWith("jar:file:/")) {
            IEditorInput jarEditorInput = this.createEditorInput(fileString = fileString.substring("jar:file:/".length()));
            IEditorPart part = this.openFileInEditor(jarEditorInput, fileString);
            if (part == null) {
                this.openFileFailed();
            }
        } else {
            super.openFileInEditor(fileString);
        }
    }

    private XModelObject getFilename(IRegion region) {
        IFile file = this.getFile();
        XModel xModel = JSPTaglibHyperlink.getXModel((IFile)file);
        if (xModel == null) {
            return null;
        }
        String uri = this.getTaglibUri(region);
        if (uri == null) {
            return null;
        }
        IWebProject wp = WebProjectFactory.instance.getWebProject(xModel);
        if (wp == null) {
            return null;
        }
        ITaglibMapping tm = wp.getTaglibMapping();
        if (tm == null) {
            return null;
        }
        return tm.getTaglibObject(uri);
    }

    private String getTaglibUri(IRegion region) {
        IStructuredModel model = null;
        try {
            IDOMDocument xmlDocument;
            model = this.getModelManager().getExistingModelForRead(this.getDocument());
            IDOMDocument iDOMDocument = xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((IDOMNode)xmlDocument, (int)region.getOffset());
            if (n instanceof IDOMAttr) {
                n = ((IDOMAttr)n).getOwnerElement();
            }
            if (!(n instanceof IDOMElement)) {
                return null;
            }
            if (!"jsp:directive.taglib".equals(n.getNodeName())) {
                return null;
            }
            IDOMElement taglib = (IDOMElement)n;
            String uri = taglib.getAttribute("uri");
            if (uri == null || uri.trim().length() == 0) {
                return null;
            }
            String string = uri;
            return string;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    private IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (!(n instanceof IDOMElement)) {
                return null;
            }
            if (!"jsp:directive.taglib".equals(n.getNodeName())) {
                return null;
            }
            IDOMElement taglib = (IDOMElement)n;
            int taglibLength = taglib.getEndOffset() - taglib.getStartOffset();
            int taglibOffset = taglib.getStartOffset();
            Region region = new Region(taglibOffset, taglibLength);
            return region;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String uri = this.getTaglibUri(this.fLastRegion);
        if (uri == null) {
            return MessageFormat.format(Messages.OpenA, Messages.TagLibrary);
        }
        return MessageFormat.format(Messages.OpenTagLibraryForUri, uri);
    }
}

