/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.text.ext.hyperlink.jsp;

import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPElementAttributeValueHyperlinkPartitioner;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSPTaglibHyperlinkPartitioner
extends JSPElementAttributeValueHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String JSP_TAGLIB_PARTITION = "org.jboss.tools.common.text.ext.jsp.JSP_TAGLIB";

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        if (document == null || superRegion == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            HyperlinkRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)superRegion.getOffset());
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (!(n instanceof Element)) {
                return null;
            }
            if (!"jsp:directive.taglib".equals(n.getNodeName())) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0) {
                return null;
            }
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = JSP_TAGLIB_PARTITION;
            int length = end - start - (superRegion.getOffset() - start);
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        if (document == null || region == null) {
            return false;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (!(n instanceof Element)) {
                return false;
            }
            boolean bl = "jsp:directive.taglib".equals(n.getNodeName());
            return bl;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAxis(IDocument document, IHyperlinkRegion superRegion) {
        if (superRegion.getAxis() == null || superRegion.getAxis().length() == 0) {
            return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis(document, superRegion.getOffset())) + "/";
        }
        return superRegion.getAxis();
    }
}

