/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.text.ext.hyperlink.jsp;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.tld.ITaglibMapping;
import org.jboss.tools.jst.web.tld.IWebProject;
import org.jboss.tools.jst.web.tld.WebProjectFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSPXmlNsHyperlink
extends AbstractHyperlink {
    protected final String JAR_FILE_PROTOCOL = "jar:file:/";
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        XModelObject object = this.getFilename(region);
        if (object != null) {
            FindObjectHelper.findModelObject((XModelObject)object, (int)FindObjectHelper.IN_EDITOR_ONLY);
        } else {
            this.openFileFailed();
        }
    }

    protected void openFileInEditor(String fileString) {
        if (fileString.startsWith("jar:file:/")) {
            IEditorInput jarEditorInput = this.createEditorInput(fileString = fileString.substring("jar:file:/".length()));
            IEditorPart part = this.openFileInEditor(jarEditorInput, fileString);
            if (part == null) {
                this.openFileFailed();
            }
        } else {
            super.openFileInEditor(fileString);
        }
    }

    private XModelObject getFilename(IRegion region) {
        IFile file = this.getFile();
        XModel xModel = JSPXmlNsHyperlink.getXModel((IFile)file);
        if (xModel == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof IDOMAttr)) {
                return null;
            }
            Attr xmlnsAttr = (Attr)n;
            if (xmlnsAttr.getName() == null || !xmlnsAttr.getName().startsWith("xmlns:")) {
                return null;
            }
            Element rootElem = xmlnsAttr.getOwnerElement();
            if (!rootElem.getNodeName().equals("jsp:root") && !rootElem.getNodeName().equalsIgnoreCase("html")) {
                return null;
            }
            String uri = xmlnsAttr.getValue();
            if (uri == null || uri.trim().length() == 0) {
                return null;
            }
            IWebProject wp = WebProjectFactory.instance.getWebProject(xModel);
            if (wp == null) {
                return null;
            }
            ITaglibMapping tm = wp.getTaglibMapping();
            if (tm == null) {
                return null;
            }
            XModelObject xModelObject = tm.getTaglibObject(uri);
            return xModelObject;
        }
        finally {
            smw.dispose();
        }
    }

    private String getUri(IRegion region) {
        IFile file = this.getFile();
        XModel xModel = JSPXmlNsHyperlink.getXModel((IFile)file);
        if (xModel == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof IDOMAttr)) {
                return null;
            }
            Attr xmlnsAttr = (Attr)n;
            if (xmlnsAttr.getName() == null || !xmlnsAttr.getName().startsWith("xmlns:")) {
                return null;
            }
            Element rootElem = xmlnsAttr.getOwnerElement();
            if (!rootElem.getNodeName().equals("jsp:root") && !rootElem.getNodeName().equalsIgnoreCase("html")) {
                return null;
            }
            String uri = xmlnsAttr.getValue();
            if (uri == null || uri.trim().length() == 0) {
                return null;
            }
            String string = uri;
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    private IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (!(n instanceof IDOMAttr)) {
                return null;
            }
            IDOMAttr xmlnsAttr = (IDOMAttr)n;
            if (xmlnsAttr.getName() == null || !xmlnsAttr.getName().startsWith("xmlns:")) {
                return null;
            }
            Element rootElem = xmlnsAttr.getOwnerElement();
            if (!rootElem.getNodeName().equals("jsp:root") && !rootElem.getNodeName().equalsIgnoreCase("html")) {
                return null;
            }
            int taglibLength = xmlnsAttr.getValueRegionText().length();
            int taglibOffset = xmlnsAttr.getValueRegionStartOffset();
            Region region = new Region(taglibOffset, taglibLength);
            return region;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String uri = this.getUri(this.fLastRegion);
        if (uri == null) {
            return MessageFormat.format(Messages.NotFound, "URI");
        }
        return MessageFormat.format(Messages.Open, uri);
    }
}

