/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.ui.vrules.preferences;

import java.util.ArrayList;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.preferences.IPreferencePageExt;
import org.jboss.tools.common.model.ui.wizards.query.list.TreeItemSelectionManager;
import org.jboss.tools.common.verification.ui.vrules.preferences.Messages;
import org.jboss.tools.common.verification.ui.vrules.wizard.DescriptionManager;
import org.jboss.tools.common.verification.ui.vrules.wizard.config.ConfigItemWrapper;
import org.jboss.tools.common.verification.ui.vrules.wizard.config.ConfigRulesProvider;
import org.jboss.tools.common.verification.ui.vrules.wizard.config.ConfigSignificanceView;
import org.jboss.tools.common.verification.ui.vrules.wizard.config.RuleSetWrapper;
import org.jboss.tools.common.verification.ui.vrules.wizard.config.RuleWrapper;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VManager;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VRuleSet;
import org.jboss.tools.common.verification.vrules.core.resources.MarkerClearer;

public class RulesConfigurationPage
extends PreferencePage
implements IPreferencePageExt,
IWorkbenchPreferencePage {
    protected ConfigSignificanceView significance = new ConfigSignificanceView();
    protected TreeViewer treeViewer;
    protected ConfigRulesProvider provider = new ConfigRulesProvider();
    protected DescriptionManager tip = new DescriptionManager();
    VManager manager;

    protected Control createContents(Composite parent) {
        this._init();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Control sc = this.significance.createControl(composite);
        sc.setLayoutData((Object)new GridData(768));
        this.treeViewer = new TreeViewer(composite, 2848);
        this.treeViewer.setContentProvider((IContentProvider)this.provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.treeViewer.setInput((Object)this);
        Control tc = this.treeViewer.getControl();
        tc.setLayoutData((Object)new GridData(1808));
        TreeItemSelectionManager m = new TreeItemSelectionManager(this.treeViewer, (TreeItemSelectionManager.Listener)new Flipper());
        this.significance.update();
        this.tip.install((Control)this.treeViewer.getTree());
        this.treeViewer.expandToLevel(2);
        m.update();
        return composite;
    }

    void _init() {
        this.manager = VHelper.getManager();
        if (this.manager == null) {
            return;
        }
        this.significance.setManager(this.manager);
        VRuleSet[] sets = this.manager.getRuleSets();
        RuleSetWrapper[] ruleSets = new RuleSetWrapper[sets == null ? 0 : sets.length];
        int i = 0;
        while (i < sets.length) {
            ruleSets[i] = new RuleSetWrapper(sets[i]);
            this.createChildren(ruleSets[i], sets[i]);
            ++i;
        }
        this.provider.setRuleSets(ruleSets);
    }

    private void createChildren(RuleSetWrapper ruleSetWrapper, VRuleSet set) {
        ArrayList<ConfigItemWrapper> list = new ArrayList<ConfigItemWrapper>();
        VRuleSet[] ss = set.getRuleSets();
        int j = 0;
        while (j < ss.length) {
            RuleSetWrapper c = new RuleSetWrapper(ss[j]);
            this.createChildren(c, ss[j]);
            c.setParent(ruleSetWrapper);
            list.add(c);
            ++j;
        }
        VRule[] rs = set.getRules();
        int j2 = 0;
        while (j2 < rs.length) {
            list.add(new RuleWrapper(rs[j2], this.significance, ruleSetWrapper));
            ++j2;
        }
        ruleSetWrapper.setChildren(list.toArray(new ConfigItemWrapper[0]));
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performCancel() {
        this._cancel();
        return super.performCancel();
    }

    private void _cancel() {
        RuleSetWrapper[] ruleSets = this.provider.getRuleSets();
        int i = 0;
        while (i < ruleSets.length) {
            ruleSets[i].cancel();
            ++i;
        }
    }

    private void setChecked(TreeItem item) {
        Object data = item.getData();
        boolean checked = true;
        if (data instanceof ConfigItemWrapper) {
            checked = ((ConfigItemWrapper)data).isSelected();
        }
        item.setChecked(checked);
        int i = 0;
        while (i < item.getItemCount()) {
            TreeItem child = item.getItem(i);
            this.setChecked(child);
            ++i;
        }
    }

    public void performDefaults() {
        RuleSetWrapper[] ruleSets = this.provider.getRuleSets();
        int i = 0;
        while (i < ruleSets.length) {
            ruleSets[i].setDefaults();
            ++i;
        }
        if (this.treeViewer != null) {
            Tree tree = this.treeViewer.getTree();
            int i2 = 0;
            while (i2 < tree.getItemCount()) {
                this.setChecked(tree.getItem(i2));
                ++i2;
            }
            this.treeViewer.refresh();
        }
        this.significance.loadDefaults();
        super.performDefaults();
    }

    public boolean performOk() {
        this.significance.commit();
        PreferenceModelUtilities.getPreferenceModel().save();
        if (this.isDisabled()) {
            MarkerClearer.clearAll();
        }
        return true;
    }

    private boolean isDisabled() {
        RuleSetWrapper[] ruleSets = this.provider.getRuleSets();
        if (ruleSets.length == 0) {
            return true;
        }
        int i = 0;
        while (i < ruleSets.length) {
            if (ruleSets[i].isSelected()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getTitle() {
        return Messages.RulesConfigurationPage_RulesConfigurationTitle;
    }

    class Flipper
    implements TreeItemSelectionManager.Listener {
        Flipper() {
        }

        public void flip(TreeItem item) {
            ConfigItemWrapper w = (ConfigItemWrapper)item.getData();
            if (!w.isEnabled()) {
                return;
            }
            w.flip();
            RulesConfigurationPage.this.treeViewer.refresh((Object)w);
        }

        public boolean isSelected(Object data) {
            ConfigItemWrapper w = (ConfigItemWrapper)data;
            return w != null && w.isSelected();
        }
    }
}

