/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.xml.model.helpers;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class HibernateTypeHelper {
    static Properties hToJ = new Properties();
    static Properties jToH = new Properties();
    static Set<String> primitives = new HashSet<String>();
    public static String[] TYPE_NAMES = new String[]{"binary", "big_decimal", "blob", "boolean", "byte", "calendar", "calendar_date", "character", "class", "clob", "currency", "date", "double", "float", "integer", "locale", "long", "serializable", "short", "string", "text", "time", "timestamp", "timezone", "true_false", "yes_no"};
    public static String[] VERSION_TYPE_NAMES = new String[]{"integer", "long", "short", "timestamp", "calendar"};
    public static String[] TIMESTAMP_TYPE_NAMES = new String[]{"timestamp"};
    public static String[] DISCRIMINATOR_TYPE_NAMES = new String[]{"string", "character", "integer", "byte", "short", "boolean", "yes_no", "true_false"};
    public static String[] COLLECTION_TYPE_NAMES = new String[]{"array", "bag", "idbag", "list", "map", "primitive-array", "set"};

    static {
        HibernateTypeHelper.addType("integer", new String[]{"int", "java.lang.Integer"}, true);
        HibernateTypeHelper.addType("long", new String[]{"long", "java.lang.Long"}, true);
        HibernateTypeHelper.addType("short", new String[]{"short", "java.lang.Short"}, true);
        HibernateTypeHelper.addType("float", new String[]{"float", "java.lang.Float"}, true);
        HibernateTypeHelper.addType("double", new String[]{"double", "java.lang.Double"}, true);
        HibernateTypeHelper.addType("character", new String[]{"char", "java.lang.Character"}, true);
        HibernateTypeHelper.addType("byte", new String[]{"byte", "java.lang.Byte"}, true);
        HibernateTypeHelper.addType("boolean", new String[]{"boolean", "java.lang.Boolean"}, true);
        HibernateTypeHelper.addType("yes_no", "boolean", true);
        HibernateTypeHelper.addType("true_false", "boolean", true);
        HibernateTypeHelper.addType("string", "java.lang.String", true);
        HibernateTypeHelper.addType("date", "java.util.Date", true);
        HibernateTypeHelper.addType("time", "java.util.Time", true);
        HibernateTypeHelper.addType("timestamp", "java.sql.Timestamp", true);
        HibernateTypeHelper.addType("calendar", "java.util.Calendar", true);
        HibernateTypeHelper.addType("calendar_date", "java.util.Calendar", true);
        HibernateTypeHelper.addType("big_decimal", "java.math.BigDecimal", true);
        HibernateTypeHelper.addType("locale", "java.util.Locale", true);
        HibernateTypeHelper.addType("timezone", "java.util.TimeZone", true);
        HibernateTypeHelper.addType("currency", "java.util.Currency", true);
        HibernateTypeHelper.addType("class", "java.lang.Class", true);
        HibernateTypeHelper.addType("text", "java.lang.String", true);
        HibernateTypeHelper.addType("binary", "byte[]", false);
        HibernateTypeHelper.addType("serializable", "java.io.Serializable", false);
        HibernateTypeHelper.addType("clob", "java.sql.Clob", false);
        HibernateTypeHelper.addType("blob", "java.sql.Blob", false);
        HibernateTypeHelper.addType("map", new String[]{"java.util.Map", "java.util.HashMap", "java.util.TreeMap"}, false);
        HibernateTypeHelper.addType("set", new String[]{"java.util.Set", "java.util.HashSet", "java.util.TreeSet"}, false);
        HibernateTypeHelper.addType("list", new String[]{"java.util.List", "java.util.ArrayList", "java.util.Vector"}, false);
        HibernateTypeHelper.addType("bag", "java.util.List", false);
        HibernateTypeHelper.addType("idbag", "java.util.List", false);
        HibernateTypeHelper.addType("array", "java.lang.String[]", false);
        HibernateTypeHelper.addType("primitive-array", "int[]", false);
    }

    private static void addType(String hibernateType, String javaType, boolean isPrimitive) {
        HibernateTypeHelper.addType(hibernateType, new String[]{javaType}, isPrimitive);
    }

    private static void addType(String hibernateType, String[] javaTypes, boolean isPrimitive) {
        hToJ.setProperty(hibernateType, javaTypes[0]);
        int i = 0;
        while (i < javaTypes.length) {
            if (!jToH.containsKey(javaTypes[i])) {
                jToH.setProperty(javaTypes[i], hibernateType);
            }
            ++i;
        }
        if (isPrimitive) {
            primitives.add(hibernateType);
            i = 0;
            while (i < javaTypes.length) {
                primitives.add(javaTypes[i]);
                ++i;
            }
        }
    }

    public static String getJavaTypeForHibernateType(String hibernateType) {
        String s = hToJ.getProperty(hibernateType);
        return s == null ? hibernateType : s;
    }

    public static String getHibernateTypeForJavaType(String javaType) {
        String s = jToH.getProperty(javaType);
        return s == null ? javaType : s;
    }

    public static boolean isPrimitive(String type) {
        return type != null && type.length() > 0 && primitives.contains(type);
    }

    public static boolean isHibernateType(String type) {
        boolean result = false;
        int i = 0;
        while (i < TYPE_NAMES.length && !result) {
            result = TYPE_NAMES[i].equals(type);
            ++i;
        }
        return result;
    }

    public static void mergeAttributes(XModelObject destination, XModelObject source) throws XModelException {
        XModelObjectLoaderUtil.mergeAttributes((XModelObject)destination, (XModelObject)source);
        if (destination.getModelEntity().getAttribute("type") != null && source.getModelEntity().getAttribute("type") == null && source.getModelEntity().getAttribute("class") != null) {
            destination.setAttributeValue("type", source.getAttributeValue("class"));
        } else if (destination.getModelEntity().getAttribute("class") != null && source.getModelEntity().getAttribute("class") == null && source.getModelEntity().getAttribute("type") != null) {
            String className = HibernateTypeHelper.getJavaTypeForHibernateType(source.getAttributeValue("type"));
            if (className == null || className.length() <= 0) {
                className = source.getAttributeValue("type");
            }
            destination.setAttributeValue("class", className);
        }
    }

    public static String getHibernateTypeBySQLType(String sqlType) {
        if (sqlType == null || sqlType.length() == 0) {
            return "";
        }
        if ("BIGINT".equals(sqlType)) {
            return "long";
        }
        if ("BINARY".equals(sqlType)) {
            return "binary";
        }
        if ("BIT".equals(sqlType)) {
            return "boolean";
        }
        if ("BLOB".equals(sqlType)) {
            return "blob";
        }
        if ("CHAR".equals(sqlType)) {
            return "string";
        }
        if ("CLOB".equals(sqlType)) {
            return "clob";
        }
        if ("DATE".equals(sqlType)) {
            return "date";
        }
        if ("DECIMAL".equals(sqlType)) {
            return "double";
        }
        if ("DOUBLE".equals(sqlType)) {
            return "double";
        }
        if ("FLOAT".equals(sqlType)) {
            return "float";
        }
        if ("INTEGER".equals(sqlType)) {
            return "integer";
        }
        if ("LONG_RAW".equals(sqlType)) {
            return "";
        }
        if ("LONGVARBINARY".equals(sqlType)) {
            return "binary";
        }
        if ("LONGVARCHAR".equals(sqlType)) {
            return "binary";
        }
        if ("NUMBER".equals(sqlType)) {
            return "integer";
        }
        if ("NUMERIC".equals(sqlType)) {
            return "integer";
        }
        if ("REAL".equals(sqlType)) {
            return "double";
        }
        if ("SMALL_INT".equals(sqlType)) {
            return "short";
        }
        if ("TIME".equals(sqlType)) {
            return "time";
        }
        if ("TIMESTAMP".equals(sqlType)) {
            return "timestamp";
        }
        if ("TINYINT".equals(sqlType)) {
            return "byte";
        }
        if ("VARBINARY".equals(sqlType)) {
            return "binary";
        }
        if ("VARCHAR".equals(sqlType)) {
            return "string";
        }
        if ("VARCHAR2".equals(sqlType)) {
            return "string";
        }
        if ("CHAR".equals(sqlType)) {
            return "string";
        }
        if ("NCHAR".equals(sqlType)) {
            return "string";
        }
        if ("DATETIME".equals(sqlType)) {
            return "date";
        }
        if ("NVARCHAR".equals(sqlType)) {
            return "string";
        }
        if ("TEXT".equals(sqlType)) {
            return "string";
        }
        if ("NTEXT".equals(sqlType)) {
            return "string";
        }
        if ("INT".equals(sqlType)) {
            return "int";
        }
        return "";
    }
}

