/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.resref.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintFileFilter;
import org.jboss.tools.common.meta.impl.XModelMetaDataImpl;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.common.model.ui.objecteditor.XTable;
import org.jboss.tools.common.model.ui.objecteditor.XTableProvider;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.common.resref.core.ResourceReferenceList;
import org.jboss.tools.common.resref.ui.Messages;
import org.jboss.tools.common.resref.ui.ResourceReferencesTableProvider;

public abstract class AbstractResourceReferencesComposite {
    protected static String ADD = Messages.AbstractResourceReferencesComposite_Add;
    protected static String EDIT = Messages.AbstractResourceReferencesComposite_Edit;
    protected static String REMOVE = Messages.AbstractResourceReferencesComposite_Remove;
    protected XTable table = new XTable();
    protected CommandBar bar = new CommandBar();
    protected ResourceReferencesTableProvider tableProvider;
    protected IFile file;
    protected IPath path;
    protected List dataList = new ArrayList();

    public AbstractResourceReferencesComposite() {
        this.init();
    }

    private void init() {
        this.tableProvider = this.createTableProvider(this.dataList);
        this.bar.getLayout().buttonWidth = 80;
        this.bar.getLayout().direction = 512;
        this.bar.setCommands(new String[]{ADD, EDIT, REMOVE});
        this.bar.addCommandBarListener((CommandBarListener)new BarListener());
        this.table.setTableProvider((XTableProvider)this.tableProvider);
    }

    protected abstract ResourceReferencesTableProvider createTableProvider(List var1);

    protected abstract ResourceReferenceList getReferenceList();

    protected abstract String createGroupLabel();

    public void setObject(Object object) {
        Properties p = (Properties)object;
        this.file = (IFile)p.get("file");
        this.path = (IPath)p.get("path");
        ResourceReference[] rs = this.file != null ? this.getReferenceList().getAllResources(this.file) : (this.path != null ? this.getReferenceList().getAllResources(this.path) : new ResourceReference[]{});
        int i = 0;
        while (i < rs.length) {
            this.dataList.add(rs[i]);
            ++i;
        }
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout g = new GridLayout(2, false);
        composite.setLayout((Layout)g);
        Control slc = this.table.createControl(composite);
        slc.setLayoutData((Object)new GridData(1808));
        Control bc = this.bar.createControl(composite);
        GridData gd = new GridData(1040);
        bc.setLayoutData((Object)gd);
        this.table.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractResourceReferencesComposite.this.updateBars();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.update();
        return composite;
    }

    protected ResourceReference[] getReferenceArray() {
        return this.dataList.toArray(new ResourceReference[0]);
    }

    public void clearAll() {
        if (this.dataList != null) {
            this.dataList.clear();
        }
    }

    public void commit() {
        if (this.file != null) {
            this.getReferenceList().setAllResources(this.file, this.getReferenceArray());
        } else {
            this.getReferenceList().setAllResources(this.path, this.getReferenceArray());
        }
    }

    protected abstract void add(int var1);

    protected ResourceReference getDefaultResourceReference() {
        return new ResourceReference("", 1);
    }

    protected abstract void edit(int var1);

    protected abstract String getEntity();

    void remove(int index) {
        if (index >= 0) {
            this.dataList.remove(index);
        }
    }

    public void update() {
        if (this.table != null) {
            this.table.update();
        }
        this.updateBars();
    }

    protected void updateBars() {
        boolean canModify = this.table.getSelectionIndex() >= 0;
        this.bar.setEnabled(EDIT, canModify);
        this.bar.setEnabled(REMOVE, canModify);
    }

    protected void initFilterInFileChooser() {
        String entityName = this.getEntity();
        XModelEntity entity = XModelMetaDataImpl.getInstance().getEntity(entityName);
        if (entity != null && this.file != null && this.file.getProject() != null) {
            XAttribute[] as = entity.getAttributes();
            int i = 0;
            while (i < as.length) {
                if (as[i].getConstraint() instanceof XAttributeConstraintFileFilter) {
                    XAttributeConstraintFileFilter f = (XAttributeConstraintFileFilter)as[i].getConstraint();
                    f.getProperties().setProperty("filterFolder", this.file.getProject().getLocation().toFile().getAbsolutePath());
                }
                ++i;
            }
        }
    }

    public class BarListener
    implements CommandBarListener {
        public void action(String command) {
            int index = AbstractResourceReferencesComposite.this.table.getSelectionIndex();
            if (ADD.equals(command)) {
                AbstractResourceReferencesComposite.this.add(index);
            } else if (EDIT.equals(command)) {
                AbstractResourceReferencesComposite.this.edit(index);
            } else if (REMOVE.equals(command)) {
                AbstractResourceReferencesComposite.this.remove(index);
            }
            AbstractResourceReferencesComposite.this.update();
        }
    }
}

