/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.xml;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.jboss.tools.common.text.xml.XmlEditorPlugin;
import org.jboss.tools.common.text.xml.contentassist.SortingCompoundContentAssistProcessor;

public class XMLTextViewerConfiguration
extends StructuredTextViewerConfigurationXML {
    SourceViewerConfiguration initial = null;

    public void setInitialConfiguration(SourceViewerConfiguration initial) {
        this.initial = initial;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] in;
        SortingCompoundContentAssistProcessor sortingCompoundProcessor = new SortingCompoundContentAssistProcessor(sourceViewer, partitionType);
        ArrayList<IContentAssistProcessor> processors = new ArrayList<IContentAssistProcessor>();
        if (sortingCompoundProcessor.supportsPartitionType(partitionType)) {
            processors.add(sortingCompoundProcessor);
        }
        if ((in = this.getInitialProcessors(sourceViewer, partitionType)) != null && in.length > 0) {
            int i = 0;
            while (i < in.length) {
                if (!processors.contains(in[i])) {
                    processors.add(in[i]);
                }
                ++i;
            }
        } else {
            IContentAssistProcessor[] ps = super.getContentAssistProcessors(sourceViewer, partitionType);
            int i = 0;
            while (ps != null && i < ps.length) {
                if (!processors.contains(ps[i])) {
                    processors.add(ps[i]);
                }
                ++i;
            }
        }
        return processors.toArray(new IContentAssistProcessor[0]);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] in;
        if (this.fPreferenceStore == null) {
            return null;
        }
        if (sourceViewer == null || !this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        ArrayList<IHyperlinkDetector> allDetectors = new ArrayList<IHyperlinkDetector>(0);
        IHyperlinkDetector extHyperlinkDetector = this.getTextEditorsExtensionsHyperlinkDetector();
        if (extHyperlinkDetector != null) {
            allDetectors.add(extHyperlinkDetector);
        }
        IHyperlinkDetector[] ts = allDetectors.toArray(new IHyperlinkDetector[0]);
        IHyperlinkDetector[] iHyperlinkDetectorArray = in = this.initial != null ? this.initial.getHyperlinkDetectors(sourceViewer) : null;
        if (in == null || in.length == 0) {
            return ts;
        }
        if (ts == null || ts.length == 0) {
            return in;
        }
        ArrayList<IHyperlinkDetector> total = new ArrayList<IHyperlinkDetector>();
        int i = 0;
        while (i < ts.length) {
            total.add(ts[i]);
            ++i;
        }
        i = 0;
        while (i < in.length) {
            if (!total.contains(in[i])) {
                total.add(in[i]);
            }
            ++i;
        }
        return total.toArray(new IHyperlinkDetector[0]);
    }

    private IHyperlinkDetector getTextEditorsExtensionsHyperlinkDetector() {
        Plugin plugin = Platform.getPlugin((String)"org.jboss.tools.common.text.ext");
        return plugin != null && plugin instanceof IAdaptable ? (IHyperlinkDetector)((IAdaptable)plugin).getAdapter(IHyperlinkDetector.class) : null;
    }

    IContentAssistProcessor[] getInitialProcessors(ISourceViewer sourceViewer, String partitionType) {
        Method m;
        block7: {
            if (this.initial == null) {
                return null;
            }
            if (!(this.initial instanceof StructuredTextViewerConfiguration)) {
                return null;
            }
            m = this.findDeclaredMethod(this.initial.getClass(), "getContentAssistProcessors", new Class[]{ISourceViewer.class, String.class});
            if (m != null) break block7;
            return null;
        }
        try {
            m.setAccessible(true);
            return (IContentAssistProcessor[])m.invoke((Object)this.initial, sourceViewer, partitionType);
        }
        catch (IllegalArgumentException e) {
            XmlEditorPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            XmlEditorPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (InvocationTargetException e) {
            XmlEditorPlugin.getPluginLog().logError((Throwable)e);
        }
        return null;
    }

    private Method findDeclaredMethod(Class cls, String name, Class[] paramTypes) {
        Class sc;
        Method[] ms = cls.getDeclaredMethods();
        if (ms != null) {
            int i = 0;
            while (i < ms.length) {
                Class<?>[] ps;
                if (ms[i].getName().equals(name) && (ps = ms[i].getParameterTypes()) != null && ps.length == paramTypes.length) {
                    boolean equal = true;
                    int j = 0;
                    while (j < ps.length && equal) {
                        if (!ps[j].getName().equals(paramTypes[j].getName())) {
                            equal = false;
                        }
                        ++j;
                    }
                    if (equal) {
                        return ms[i];
                    }
                }
                ++i;
            }
        }
        if ((sc = cls.getSuperclass()) == null || sc == Object.class) {
            return null;
        }
        return this.findDeclaredMethod(sc, name, paramTypes);
    }
}

