/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.xml.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.ui.internal.extension.RegistryReader;
import org.eclipse.wst.sse.ui.internal.util.Sorter;
import org.jboss.tools.common.text.xml.contentassist.ContentAssistProcessorDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentAssistProcessorBuilder
extends RegistryReader {
    public static final String PL_CONTENTASSISTPROCESSOR = "contentAssistProcessor";
    public static final String TAG_CONTENTASSISTPROCESSOR = "contentAssistProcessor";
    public static final String TAG_CONTENT_TYPE = "contenttype";
    public static final String TAG_PARTITION_TYPE = "partitiontype";
    public static final String ATT_ID = "id";
    public static final String ATT_CLASS = "class";
    protected String targetContributionTag;
    private static ContentAssistProcessorBuilder fInstance;
    private List<ContentAssistProcessorDefinition> fContentAssistProcessorDefs = null;
    private ContentAssistProcessorDefinition fCurrentDefinition = null;
    private String fCurrentDefinitionContentType = null;

    public static synchronized ContentAssistProcessorBuilder getInstance() {
        if (fInstance == null) {
            fInstance = new ContentAssistProcessorBuilder();
        }
        return fInstance;
    }

    protected String getId(IConfigurationElement element) {
        String value = element.getAttribute(ATT_ID);
        return value;
    }

    protected String getContentAssistProcessorClass(IConfigurationElement element) {
        String value = element.getAttribute(ATT_CLASS);
        return value;
    }

    private void processContentAssistProcessorTag(IConfigurationElement element) {
        String theId = this.getId(element);
        String theClass = this.getContentAssistProcessorClass(element);
        if (theId != null && theClass != null) {
            this.fCurrentDefinition = new ContentAssistProcessorDefinition(theId, theClass, element);
            if (this.fContentAssistProcessorDefs == null) {
                this.fContentAssistProcessorDefs = new ArrayList<ContentAssistProcessorDefinition>();
            }
            this.fContentAssistProcessorDefs.add(this.fCurrentDefinition);
        } else {
            this.fCurrentDefinition = null;
        }
    }

    private void processContentTypeTag(IConfigurationElement element) {
        String theId = this.getId(element);
        this.fCurrentDefinitionContentType = theId != null && this.fCurrentDefinition != null ? theId : null;
    }

    private void processPartitionTypeTag(IConfigurationElement element) {
        String theId = this.getId(element);
        if (theId != null && this.fCurrentDefinition != null && this.fCurrentDefinitionContentType != null) {
            this.fCurrentDefinition.addPartitionType(this.fCurrentDefinitionContentType, theId);
        }
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(this.targetContributionTag)) {
            this.processContentAssistProcessorTag(element);
            if (this.fCurrentDefinition != null) {
                this.readElementChildren(element);
            }
            return true;
        }
        if (tag.equals(TAG_CONTENT_TYPE)) {
            this.processContentTypeTag(element);
            if (this.fCurrentDefinition != null) {
                this.readElementChildren(element);
            }
            return true;
        }
        if (tag.equals(TAG_PARTITION_TYPE)) {
            this.processPartitionTypeTag(element);
            return true;
        }
        return false;
    }

    private void initCache() {
        if (this.fContentAssistProcessorDefs == null) {
            this.readContributions("contentAssistProcessor", "contentAssistProcessor");
        }
    }

    public ContentAssistProcessorDefinition[] getContentAssistProcessorDefinitions() {
        this.initCache();
        return this.fContentAssistProcessorDefs == null ? new ContentAssistProcessorDefinition[]{} : this.fContentAssistProcessorDefs.toArray(new ContentAssistProcessorDefinition[this.fContentAssistProcessorDefs.size()]);
    }

    public Collection<String> getContentAssistProcessorContentTypes(String partitionType) {
        if (partitionType == null) {
            return null;
        }
        ContentAssistProcessorDefinition[] allDefs = this.getContentAssistProcessorDefinitions();
        new ArrayList();
        new ArrayList();
        HashSet<String> validContentTypes = new HashSet<String>();
        int i = 0;
        while (i < allDefs.length) {
            Collection<String> contentTypes = allDefs[i].getContentTypes();
            if (contentTypes != null) {
                validContentTypes.addAll(contentTypes);
            }
            ++i;
        }
        return validContentTypes;
    }

    public ContentAssistProcessorDefinition[] getContentAssistProcessorDefinitions(String partitionType) {
        if (partitionType == null) {
            return null;
        }
        ContentAssistProcessorDefinition[] allDefs = this.getContentAssistProcessorDefinitions();
        ArrayList<ContentAssistProcessorDefinition> defs = new ArrayList<ContentAssistProcessorDefinition>();
        ArrayList<ContentAssistProcessorDefinition> lastDefs = new ArrayList<ContentAssistProcessorDefinition>();
        int i = 0;
        while (i < allDefs.length) {
            for (String contentType : allDefs[i].getContentTypes()) {
                List<String> partitions = allDefs[i].getPartitionTypes(contentType);
                if (partitions == null) continue;
                if (partitions.isEmpty()) {
                    lastDefs.add(allDefs[i]);
                    continue;
                }
                int j = 0;
                boolean added = false;
                while (j < partitions.size() && !added) {
                    if (partitionType.equals(partitions.get(j))) {
                        defs.add(allDefs[i]);
                        added = true;
                        continue;
                    }
                    ++j;
                }
            }
            ++i;
        }
        defs.addAll(lastDefs);
        return defs.toArray(new ContentAssistProcessorDefinition[defs.size()]);
    }

    protected void readContributions(String tag, String extensionPoint) {
        this.targetContributionTag = tag;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.readRegistry(registry, "org.jboss.tools.common.text.xml", extensionPoint);
    }

    protected IExtension[] orderExtensions(IExtension[] extensions) {
        Object[] sorted = this.createSorter().sort((Object[])extensions);
        IExtension[] sortedExtension = new IExtension[sorted.length];
        System.arraycopy(sorted, 0, sortedExtension, 0, sorted.length);
        return sortedExtension;
    }

    protected Sorter createSorter() {
        return new Sorter(){

            public boolean compare(Object extension1, Object extension2) {
                String s1 = ((IExtension)extension1).getUniqueIdentifier().toUpperCase();
                String s2 = ((IExtension)extension2).getUniqueIdentifier().toUpperCase();
                return s2.compareTo(s1) > 0;
            }
        };
    }

    protected void logUnknownElement(IConfigurationElement element) {
    }
}

