/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.xml.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.custom.BusyIndicator;
import org.jboss.tools.common.text.xml.XmlEditorPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentAssistProcessorDefinition {
    private String fId = null;
    private String fClassName = null;
    private Map<String, List<String>> fContentTypes = null;
    private IConfigurationElement fConfigurationElement = null;

    public ContentAssistProcessorDefinition(String id, String class1, IConfigurationElement configurationElement) {
        this.fId = id;
        this.fClassName = class1;
        this.fConfigurationElement = configurationElement;
        this.fContentTypes = new HashMap<String, List<String>>();
    }

    public void addPartitionType(String contentType, String partitionType) {
        List<String> partitionTypes = new ArrayList<String>();
        if (this.fContentTypes.containsKey(contentType)) {
            partitionTypes = this.fContentTypes.get(contentType);
        }
        if (!partitionTypes.contains(partitionType)) {
            partitionTypes.add(partitionType);
            this.fContentTypes.put(contentType, partitionTypes);
        }
    }

    public String getClassName() {
        return this.fClassName;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfigurationElement;
    }

    public String getId() {
        return this.fId;
    }

    public IContentAssistProcessor createContentAssistProcessor() {
        IContentAssistProcessor contentAssistProcessor = null;
        if (this.getClassName() != null) {
            contentAssistProcessor = (IContentAssistProcessor)this.createExtension("class");
        }
        return contentAssistProcessor;
    }

    private Object createExtension(String propertyName) {
        final IConfigurationElement element = this.getConfigurationElement();
        final String name = propertyName;
        final Object[] result = new Object[1];
        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
        if (bundle.getState() == 32) {
            try {
                return element.createExecutableExtension(name);
            }
            catch (CoreException e) {
                this.handleCreateExecutableException(result, (Exception)((Object)e));
            }
        } else {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    try {
                        result[0] = element.createExecutableExtension(name);
                    }
                    catch (CoreException e) {
                        ContentAssistProcessorDefinition.this.handleCreateExecutableException(result, (Exception)((Object)e));
                    }
                }
            });
        }
        return result[0];
    }

    private void handleCreateExecutableException(Object[] result, Exception x) {
        XmlEditorPlugin.getPluginLog().logError("Error in creating extension", (Throwable)x);
        result[0] = null;
    }

    public Collection<String> getContentTypes() {
        return this.fContentTypes.keySet();
    }

    public List<String> getPartitionTypes(String contentType) {
        return this.fContentTypes == null || !this.fContentTypes.containsKey(contentType) ? new ArrayList<String>() : this.fContentTypes.get(contentType);
    }
}

