/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.xml.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.sse.ui.internal.contentassist.IRelevanceCompletionProposal;
import org.eclipse.wst.sse.ui.internal.util.Sorter;
import org.jboss.tools.common.text.xml.contentassist.ContentAssistProcessorBuilder;
import org.jboss.tools.common.text.xml.contentassist.ContentAssistProcessorDefinition;

public class SortingCompoundContentAssistProcessor
implements IContentAssistProcessor {
    private ISourceViewer fSourceViewer;
    private String fPartitionType;
    private String fErrorMessage;
    private Map<String, Map<String, List<IContentAssistProcessor>>> fProcessorsMap;
    private static final String POST_INSTALL_CA_PROCESSORS_CONTENTTYPE_STUB = "$$POST_INSTALL_CA_PROCESSORS_CONTENTTYPE_STUB$$";

    public SortingCompoundContentAssistProcessor(ISourceViewer sourceViewer, String partitionType) {
        this.fSourceViewer = sourceViewer;
        this.fPartitionType = partitionType;
        this.init();
    }

    public boolean supportsPartitionType(String partitionType) {
        if (this.fProcessorsMap == null) {
            return false;
        }
        for (String contentType : this.fProcessorsMap.keySet()) {
            Map<String, List<IContentAssistProcessor>> partitionTypes = this.fProcessorsMap.get(contentType);
            if (partitionTypes == null || !partitionTypes.containsKey(partitionType)) continue;
            return true;
        }
        return false;
    }

    void init() {
        ContentAssistProcessorDefinition[] defs = ContentAssistProcessorBuilder.getInstance().getContentAssistProcessorDefinitions(this.fPartitionType);
        if (defs == null || defs.length == 0) {
            return;
        }
        if (this.fProcessorsMap == null) {
            this.fProcessorsMap = new HashMap<String, Map<String, List<IContentAssistProcessor>>>();
        }
        int i = 0;
        while (i < defs.length) {
            IContentAssistProcessor processor = defs[i].createContentAssistProcessor();
            Collection<String> contentTypes = defs[i].getContentTypes();
            if (contentTypes != null) {
                for (String contentType : contentTypes) {
                    Map<String, List<IContentAssistProcessor>> contentTypeProcessors = this.fProcessorsMap.get(contentType);
                    if (contentTypeProcessors == null) {
                        contentTypeProcessors = new HashMap<String, List<IContentAssistProcessor>>();
                    }
                    List<String> partitionTypes = defs[i].getPartitionTypes(contentType);
                    for (String partitionType : partitionTypes) {
                        List<IContentAssistProcessor> partitionTypeProcessors = contentTypeProcessors.get(partitionType);
                        if (partitionTypeProcessors == null) {
                            partitionTypeProcessors = new ArrayList<IContentAssistProcessor>();
                        }
                        if (!this.containsAnObjectOfTheSameType(partitionTypeProcessors, processor)) {
                            partitionTypeProcessors.add(processor);
                        }
                        if (contentTypeProcessors.containsKey(partitionType)) continue;
                        contentTypeProcessors.put(partitionType, partitionTypeProcessors);
                    }
                    if (this.fProcessorsMap.containsKey(contentType)) continue;
                    this.fProcessorsMap.put(contentType, contentTypeProcessors);
                }
            }
            ++i;
        }
    }

    public void addContentAssistProcessor(String partitionType, IContentAssistProcessor processor) {
        List<IContentAssistProcessor> partitionTypeProcessors;
        if (partitionType == null || processor == null) {
            return;
        }
        Map<String, List<IContentAssistProcessor>> contentTypeProcessors = this.fProcessorsMap.get(POST_INSTALL_CA_PROCESSORS_CONTENTTYPE_STUB);
        if (contentTypeProcessors == null) {
            contentTypeProcessors = new HashMap<String, List<IContentAssistProcessor>>();
        }
        if ((partitionTypeProcessors = contentTypeProcessors.get(partitionType)) == null) {
            partitionTypeProcessors = new ArrayList<IContentAssistProcessor>();
        }
        if (!this.containsAnObjectOfTheSameType(partitionTypeProcessors, processor)) {
            partitionTypeProcessors.add(processor);
        }
        if (!contentTypeProcessors.containsKey(partitionType)) {
            contentTypeProcessors.put(partitionType, partitionTypeProcessors);
        }
        if (!this.fProcessorsMap.containsKey(POST_INSTALL_CA_PROCESSORS_CONTENTTYPE_STUB)) {
            this.fProcessorsMap.put(POST_INSTALL_CA_PROCESSORS_CONTENTTYPE_STUB, contentTypeProcessors);
        }
    }

    boolean containsAnObjectOfTheSameType(Collection collection, Object obj) {
        if (collection == null || obj == null) {
            return false;
        }
        String objClassName = obj.getClass().getName();
        if (objClassName == null) {
            return false;
        }
        for (Object o : collection) {
            if (o == null || o.getClass() == null || !objClassName.equals(o.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    protected String getContentType(ISourceViewer viewer) {
        if (viewer == null || viewer.getDocument() == null) {
            return null;
        }
        String type = null;
        IModelManager mgr = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = mgr.getExistingModelForRead(viewer.getDocument());
            if (model != null) {
                type = model.getContentTypeIdentifier();
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return type;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        List<IContentAssistProcessor> list;
        this.fErrorMessage = null;
        String contentType = this.getContentType(this.fSourceViewer);
        if (contentType == null) {
            return new ICompletionProposal[0];
        }
        LinkedList<ICompletionProposal> ret = new LinkedList<ICompletionProposal>();
        LinkedList<IContentAssistProcessor> processors = new LinkedList<IContentAssistProcessor>();
        if (this.fProcessorsMap.get(contentType) != null && (list = this.fProcessorsMap.get(contentType).get(this.fPartitionType)) != null) {
            processors.addAll(list);
        }
        if (this.fProcessorsMap.get(POST_INSTALL_CA_PROCESSORS_CONTENTTYPE_STUB) != null && (list = this.fProcessorsMap.get(POST_INSTALL_CA_PROCESSORS_CONTENTTYPE_STUB).get(this.fPartitionType)) != null) {
            processors.addAll(list);
        }
        if (processors.size() == 0) {
            return new ICompletionProposal[0];
        }
        for (IContentAssistProcessor p : processors) {
            String errorMessage;
            ICompletionProposal[] proposals = p.computeCompletionProposals(viewer, offset);
            if (proposals != null && proposals.length > 0) {
                ret.addAll(Arrays.asList(proposals));
                this.fErrorMessage = null;
                continue;
            }
            if (this.fErrorMessage != null || !ret.isEmpty() || (errorMessage = p.getErrorMessage()) == null) continue;
            this.fErrorMessage = errorMessage;
        }
        Object[] resultArray = ret.toArray(new ICompletionProposal[ret.size()]);
        Object[] sorted = this.createSorter().sort(resultArray);
        System.arraycopy(sorted, 0, resultArray, 0, sorted.length);
        resultArray = this.makeUnique((ICompletionProposal[])resultArray);
        return resultArray;
    }

    public ICompletionProposal[] makeUnique(ICompletionProposal[] proposals) {
        if (proposals == null) {
            return null;
        }
        HashMap<String, ICompletionProposal> existingProposals = new HashMap<String, ICompletionProposal>(proposals.length);
        ArrayList<ICompletionProposal> unique = new ArrayList<ICompletionProposal>(proposals.length);
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            if (proposal != null) {
                String replString = null;
                String dispString = null;
                if (proposal instanceof CustomCompletionProposal) {
                    replString = ((CustomCompletionProposal)proposal).getReplacementString();
                }
                dispString = this.unQuote(proposal.getDisplayString());
                ICompletionProposal existingProposal = (ICompletionProposal)existingProposals.get(replString = this.getReplacementWord(replString == null ? dispString : replString));
                if (existingProposal == null) {
                    existingProposals.put(replString, proposal);
                    unique.add(proposal);
                }
            }
            ++n2;
        }
        return unique.toArray(new ICompletionProposal[unique.size()]);
    }

    private String getReplacementWord(String replacement) {
        replacement = replacement == null ? "" : replacement;
        int index = replacement.indexOf(62);
        if (index != -1 && (replacement = replacement.substring(0, index).trim()).endsWith("/")) {
            replacement = replacement.substring(0, replacement.length() - 1).trim();
        }
        if ((index = replacement.indexOf("=")) != -1) {
            replacement = replacement.substring(0, index).trim();
        }
        if ((index = replacement.indexOf(" ")) != -1) {
            replacement = replacement.substring(0, index).trim();
        }
        return replacement;
    }

    private String unQuote(String str) {
        String string = str = str == null ? "" : str.toLowerCase();
        if (str.startsWith("\"")) {
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        str = str.trim().toLowerCase();
        return str;
    }

    protected Sorter createSorter() {
        return new Sorter(){

            public boolean compare(Object proposal1, Object proposal2) {
                int pr1 = Integer.MIN_VALUE;
                int pr2 = Integer.MIN_VALUE;
                ICompletionProposal p1 = (ICompletionProposal)proposal1;
                ICompletionProposal p2 = (ICompletionProposal)proposal2;
                if (p1 instanceof IRelevanceCompletionProposal) {
                    pr1 = ((IRelevanceCompletionProposal)p1).getRelevance();
                }
                if (p2 instanceof IRelevanceCompletionProposal) {
                    pr2 = ((IRelevanceCompletionProposal)p2).getRelevance();
                }
                if (pr1 == pr2) {
                    String str2;
                    String str1 = p1.getDisplayString() == null ? "" : p1.getDisplayString();
                    String string = str2 = p2.getDisplayString() == null ? "" : p2.getDisplayString();
                    return str2.compareTo(str1) > 0;
                }
                return pr1 > pr2;
            }
        };
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        this.fErrorMessage = null;
        String contentType = this.getContentType(this.fSourceViewer);
        if (contentType == null) {
            return new IContextInformation[0];
        }
        LinkedList<ContextInformation> ret = new LinkedList<ContextInformation>();
        if (this.fProcessorsMap.get(contentType) == null) {
            return new IContextInformation[0];
        }
        if (this.fProcessorsMap.get(contentType).get(this.fPartitionType) == null) {
            return new IContextInformation[0];
        }
        for (IContentAssistProcessor p : this.fProcessorsMap.get(contentType).get(this.fPartitionType)) {
            String errorMessage;
            IContextInformation[] informations = p.computeContextInformation(viewer, offset);
            if (informations != null && informations.length > 0) {
                int i = 0;
                while (i < informations.length) {
                    ret.add(new ContextInformation(informations[i], p));
                    ++i;
                }
                this.fErrorMessage = null;
                continue;
            }
            if (this.fErrorMessage != null || !ret.isEmpty() || (errorMessage = p.getErrorMessage()) == null) continue;
            this.fErrorMessage = errorMessage;
        }
        return ret.toArray(new IContextInformation[ret.size()]);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        String contentType = this.getContentType(this.fSourceViewer);
        if (contentType == null) {
            return new char[0];
        }
        LinkedList<Character> ret = new LinkedList<Character>();
        if (this.fProcessorsMap.get(contentType) == null) {
            return new char[0];
        }
        if (this.fProcessorsMap.get(contentType).get(this.fPartitionType) == null) {
            return new char[0];
        }
        for (IContentAssistProcessor p : this.fProcessorsMap.get(contentType).get(this.fPartitionType)) {
            char[] chars = p.getCompletionProposalAutoActivationCharacters();
            if (chars == null) continue;
            int i = 0;
            while (i < chars.length) {
                ret.add(new Character(chars[i]));
                ++i;
            }
        }
        char[] chars = new char[ret.size()];
        int i = 0;
        for (Character ch : ret) {
            chars[i] = ch.charValue();
            ++i;
        }
        return chars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        String contentType = this.getContentType(this.fSourceViewer);
        if (contentType == null) {
            return new char[0];
        }
        LinkedList<Character> ret = new LinkedList<Character>();
        if (this.fProcessorsMap.get(contentType) == null) {
            return new char[0];
        }
        if (this.fProcessorsMap.get(contentType).get(this.fPartitionType) == null) {
            return new char[0];
        }
        for (IContentAssistProcessor p : this.fProcessorsMap.get(contentType).get(this.fPartitionType)) {
            char[] chars = p.getContextInformationAutoActivationCharacters();
            if (chars == null) continue;
            int i = 0;
            while (i < chars.length) {
                ret.add(new Character(chars[i]));
                ++i;
            }
        }
        char[] chars = new char[ret.size()];
        int i = 0;
        for (Character ch : ret) {
            chars[i] = ch.charValue();
            ++i;
        }
        return chars;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        boolean hasValidator = false;
        boolean hasPresenter = false;
        String contentType = this.getContentType(this.fSourceViewer);
        if (contentType == null) {
            return null;
        }
        if (this.fProcessorsMap.get(contentType) == null) {
            return null;
        }
        if (this.fProcessorsMap.get(contentType).get(this.fPartitionType) == null) {
            return null;
        }
        for (IContentAssistProcessor p : this.fProcessorsMap.get(contentType).get(this.fPartitionType)) {
            IContextInformationValidator v = p.getContextInformationValidator();
            if (v == null) continue;
            hasValidator = true;
            if (!(v instanceof IContextInformationPresenter)) continue;
            hasPresenter = true;
        }
        SortingCompoundContentAssistValidator validator = null;
        if (hasPresenter) {
            validator = new SortingCompoundContentAssistValidatorPresenter();
        } else if (hasValidator) {
            validator = new SortingCompoundContentAssistValidator(null, null);
        }
        if (validator != null) {
            for (IContentAssistProcessor p : this.fProcessorsMap.get(contentType).get(this.fPartitionType)) {
                IContextInformationValidator v = p.getContextInformationValidator();
                if (v == null) continue;
                validator.add(v);
            }
        }
        return validator;
    }

    static class ContextInformation
    implements IContextInformation,
    IContextInformationExtension {
        private IContextInformation fInfo;
        private IContentAssistProcessor fProcessor;

        ContextInformation(IContextInformation info, IContentAssistProcessor processor) {
            this.fInfo = info;
            this.fProcessor = processor;
        }

        public boolean equals(Object obj) {
            return this.fInfo.equals(obj);
        }

        public String getContextDisplayString() {
            return this.fInfo.getContextDisplayString();
        }

        public Image getImage() {
            return this.fInfo.getImage();
        }

        public String getInformationDisplayString() {
            return this.fInfo.getInformationDisplayString();
        }

        public int hashCode() {
            return this.fInfo.hashCode();
        }

        public String toString() {
            return this.fInfo.toString();
        }

        IContentAssistProcessor getProcessor() {
            return this.fProcessor;
        }

        IContextInformation getContextInformation() {
            return this.fInfo;
        }

        public int getContextInformationPosition() {
            int position = -1;
            if (this.fInfo instanceof IContextInformationExtension) {
                position = ((IContextInformationExtension)this.fInfo).getContextInformationPosition();
            }
            return position;
        }
    }

    private static class SortingCompoundContentAssistValidator
    implements IContextInformationValidator {
        List<IContextInformationValidator> fValidators = new ArrayList<IContextInformationValidator>();
        IContextInformationValidator fValidator;

        private SortingCompoundContentAssistValidator() {
        }

        void add(IContextInformationValidator validator) {
            this.fValidators.add(validator);
        }

        public void install(IContextInformation info, ITextViewer viewer, int documentPosition) {
            this.fValidator = this.getValidator(info);
            IContextInformation realInfo = this.getContextInformation(info);
            if (this.fValidator != null) {
                this.fValidator.install(realInfo, viewer, documentPosition);
            } else {
                for (IContextInformationValidator v : this.fValidators) {
                    v.install(realInfo, viewer, documentPosition);
                }
            }
        }

        IContextInformationValidator getValidator(IContextInformation info) {
            if (info instanceof ContextInformation) {
                ContextInformation wrap = (ContextInformation)info;
                return wrap.getProcessor().getContextInformationValidator();
            }
            return null;
        }

        IContextInformation getContextInformation(IContextInformation info) {
            IContextInformation realInfo = info;
            if (info instanceof ContextInformation) {
                ContextInformation wrap = (ContextInformation)info;
                realInfo = wrap.getContextInformation();
            }
            return realInfo;
        }

        public boolean isContextInformationValid(int documentPosition) {
            boolean isValid = false;
            if (this.fValidator != null) {
                isValid = this.fValidator.isContextInformationValid(documentPosition);
            } else {
                for (IContextInformationValidator v : this.fValidators) {
                    isValid |= v.isContextInformationValid(documentPosition);
                }
            }
            return isValid;
        }

        /* synthetic */ SortingCompoundContentAssistValidator(SortingCompoundContentAssistValidator sortingCompoundContentAssistValidator, SortingCompoundContentAssistValidator sortingCompoundContentAssistValidator2) {
            this();
        }
    }

    private static class SortingCompoundContentAssistValidatorPresenter
    extends SortingCompoundContentAssistValidator
    implements IContextInformationPresenter {
        private SortingCompoundContentAssistValidatorPresenter() {
        }

        public boolean updatePresentation(int offset, TextPresentation presentation) {
            boolean presentationUpdated = false;
            if (this.fValidator instanceof IContextInformationPresenter) {
                presentationUpdated = ((IContextInformationPresenter)this.fValidator).updatePresentation(offset, presentation);
            } else {
                for (IContextInformationValidator v : this.fValidators) {
                    if (!(v instanceof IContextInformationPresenter)) continue;
                    presentationUpdated |= ((IContextInformationPresenter)v).updatePresentation(offset, presentation);
                }
            }
            return presentationUpdated;
        }
    }
}

