/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.xml.ui.xpl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.common.text.xml.XmlEditorPlugin;
import org.jboss.tools.common.text.xml.ui.xpl.BasePreferenceConstants;

public class XmlPreferenceConstants
extends BasePreferenceConstants {
    public static final String EDITOR_MATCHING_BRACKETS = "matchingBrackets";
    public static final String EDITOR_MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    public static final String EDITOR_CURRENT_LINE = "currentLine";
    public static final String EDITOR_CURRENT_LINE_COLOR = "currentLineColor";
    public static final String EDITOR_PRINT_MARGIN = "printMargin";
    public static final String EDITOR_PRINT_MARGIN_COLOR = "printMarginColor";
    public static final String EDITOR_PRINT_MARGIN_COLUMN = "printMarginColumn";
    public static final String EDITOR_LINE_NUMBER_RULER = "lineNumberRuler";
    public static final String EDITOR_LINE_NUMBER_RULER_COLOR = "lineNumberColor";
    static String[] BOOLEAN_PROPERTIES = new String[]{"currentLine", "lineNumberRuler", "printMargin", "overviewRuler"};
    static String[] STRING_PROPERTIES = new String[]{"currentLineColor", "lineNumberColor", "printMarginColor", "errorIndicationColor", "warningIndicationColor", "infoIndicationColor", "taskIndicationColor", "bookmarkIndicationColor"};
    static String[] INT_PROPERTIES = new String[]{"printMarginColumn"};

    private XmlPreferenceConstants() {
    }

    public static void initializeDefaultValues(IPreferenceStore store) {
        store.setDefault(EDITOR_MATCHING_BRACKETS, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_MATCHING_BRACKETS_COLOR, (RGB)new RGB(192, 192, 192));
        store.setDefault(EDITOR_CURRENT_LINE, true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_CURRENT_LINE_COLOR, (RGB)new RGB(225, 235, 224));
        store.setDefault(EDITOR_PRINT_MARGIN, false);
        store.setDefault(EDITOR_PRINT_MARGIN_COLUMN, 80);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_PRINT_MARGIN_COLOR, (RGB)new RGB(176, 180, 185));
        store.setDefault(EDITOR_LINE_NUMBER_RULER, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_LINE_NUMBER_RULER_COLOR, (RGB)new RGB(0, 0, 0));
        store.setDefault("org.jboss.tools.common.text.xml.ui.tab.width", 4);
        store.setDefault("org.jboss.tools.common.text.xml.ui.tab.replace", false);
        XmlPreferenceConstants.setDefault(store, "errorIndicationColor", new RGB(255, 175, 175), new RGB(255, 255, 255), false, false);
        XmlPreferenceConstants.initializeTextEditorValues(store);
    }

    private static void initializeTextEditorValues(final IPreferenceStore store) {
        String p;
        Plugin plugin = Platform.getPlugin((String)"org.eclipse.ui.editors");
        try {
            Method m = AbstractUIPlugin.class.getDeclaredMethod("initializeDefaultPluginPreferences", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)plugin, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException e3) {
            XmlEditorPlugin.getPluginLog().logError((Throwable)e3);
        }
        catch (InvocationTargetException e4) {
            XmlEditorPlugin.getPluginLog().logError((Throwable)e4);
        }
        final IPreferenceStore editorsStore = ((AbstractUIPlugin)plugin).getPreferenceStore();
        int i = 0;
        while (i < BOOLEAN_PROPERTIES.length) {
            p = BOOLEAN_PROPERTIES[i];
            store.setValue(p, editorsStore.getBoolean(p));
            ++i;
        }
        i = 0;
        while (i < STRING_PROPERTIES.length) {
            p = STRING_PROPERTIES[i];
            store.setValue(p, editorsStore.getString(p));
            ++i;
        }
        i = 0;
        while (i < INT_PROPERTIES.length) {
            p = INT_PROPERTIES[i];
            store.setValue(p, editorsStore.getInt(p));
            ++i;
        }
        store.setDefault("errorIndicationInVerticalRuler", true);
        store.setDefault("warningIndicationInVerticalRuler", true);
        editorsStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String p;
                int i = 0;
                while (i < BOOLEAN_PROPERTIES.length) {
                    p = BOOLEAN_PROPERTIES[i];
                    if (event.getProperty().equals(p)) {
                        store.setValue(p, editorsStore.getBoolean(p));
                        return;
                    }
                    ++i;
                }
                i = 0;
                while (i < STRING_PROPERTIES.length) {
                    p = STRING_PROPERTIES[i];
                    if (event.getProperty().equals(p)) {
                        store.setValue(p, editorsStore.getString(p));
                        return;
                    }
                    ++i;
                }
                i = 0;
                while (i < INT_PROPERTIES.length) {
                    p = INT_PROPERTIES[i];
                    if (event.getProperty().equals(p)) {
                        store.setValue(p, editorsStore.getInt(p));
                        return;
                    }
                    ++i;
                }
            }
        });
    }
}

