/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.ui.editor.edit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.RelativeHandleLocator;
import org.eclipse.gef.handles.SquareHandle;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Cursor;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.jst.web.tiles.ui.TilesUIPlugin;
import org.jboss.tools.jst.web.tiles.ui.editor.edit.DefinitionEditPolicy;
import org.jboss.tools.jst.web.tiles.ui.editor.edit.TilesEditPart;
import org.jboss.tools.jst.web.tiles.ui.editor.figures.DefinitionFigure;
import org.jboss.tools.jst.web.tiles.ui.editor.model.IDefinition;
import org.jboss.tools.jst.web.tiles.ui.editor.model.IDefinitionListener;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ILink;

public class DefinitionEditPart
extends TilesEditPart
implements PropertyChangeListener,
IDefinitionListener,
EditPartListener {
    private DefinitionFigure fig = null;

    public void doDoubleClick(boolean cf) {
        try {
            XAction action = DnDUtil.getEnabledAction((XModelObject)((XModelObject)this.getDefinitionModel().getSource()), null, (String)"Open");
            if (action != null) {
                action.executeHandler((XModelObject)this.getDefinitionModel().getSource(), null);
            }
        }
        catch (Exception e) {
            TilesUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void deactivate() {
        this.getDefinitionModel().removePropertyChangeListener(this);
        this.getDefinitionModel().removeDefinitionListener(this);
        super.deactivate();
    }

    public void definitionChange() {
        this.refresh();
        this.fig.refreshFont();
        this.fig.repaint();
    }

    public boolean isDefinitionListenerEnable() {
        return true;
    }

    public void doControlUp() {
    }

    public void doControlDown() {
    }

    public void doMouseHover(boolean cf) {
    }

    public void setModel(Object model) {
        super.setModel(model);
        ((IDefinition)model).addPropertyChangeListener(this);
        ((IDefinition)model).addDefinitionListener(this);
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void linkAdd(ILink link) {
        this.refreshTargetLink(link);
        this.refresh();
        List editParts = this.getSourceConnections();
        int i = 0;
        while (i < editParts.size()) {
            ((ConnectionEditPart)editParts.get(i)).refresh();
            ++i;
        }
        this.getFigure().getParent().getLayoutManager().layout(this.getFigure().getParent());
    }

    private void refreshTargetLink(ILink link) {
        if (link == null) {
            return;
        }
        DefinitionEditPart gep = (DefinitionEditPart)this.getViewer().getEditPartRegistry().get(link.getToDefinition());
        if (gep == null) {
            return;
        }
        gep.refreshTargetConnections();
        gep.figure.repaint();
    }

    public void linkRemove(ILink link) {
        this.refresh();
        this.refreshTargetLink(link);
        this.refresh();
        this.getFigure().getParent().getLayoutManager().layout(this.getFigure().getParent());
    }

    public void linkChange(ILink link, PropertyChangeEvent evet) {
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = "EditPart";
            }

            public void getValue(AccessibleControlEvent e) {
            }
        };
    }

    protected List getModelTargetConnections() {
        return this.getDefinitionModel().getVisibleInputLinks();
    }

    protected List getModelSourceConnections() {
        if (this.getDefinitionModel().getLink() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(this.getDefinitionModel().getLink());
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("NodeEditPolicy", null);
        TilesNonResizableEditPolicy p = new TilesNonResizableEditPolicy();
        p.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)p);
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DefinitionEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new DefinitionEditPolicy());
    }

    protected IFigure createFigure() {
        this.fig = new DefinitionFigure(this.getDefinitionModel());
        this.fig.setGroupEditPart(this);
        return this.fig;
    }

    public DefinitionFigure getDefinitionFigure() {
        return (DefinitionFigure)this.getFigure();
    }

    public IDefinition getDefinitionModel() {
        return (IDefinition)this.getModel();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        ConnectionAnchor anc = this.getNodeFigure().getConnectionAnchor("1_IN");
        return anc;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        return this.getNodeFigure().getTargetConnectionAnchorAt(pt);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        return this.getNodeFigure().getConnectionAnchor("1_OUT");
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        return this.getNodeFigure().getSourceConnectionAnchorAt(pt);
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public class SelectHandle
    extends SquareHandle {
        public SelectHandle(GraphicalEditPart owner, int direction) {
            this.setOwner(owner);
            this.setLocator((Locator)new RelativeHandleLocator(owner.getFigure(), direction));
            this.setCursor(SharedCursors.NO);
        }

        public SelectHandle(GraphicalEditPart owner, Locator loc, Cursor c) {
            super(owner, loc, c);
        }

        protected DragTracker createDragTracker() {
            return null;
        }
    }

    class TilesNonResizableEditPolicy
    extends NonResizableEditPolicy {
        protected List createSelectionHandles() {
            ArrayList<Handle> list = new ArrayList<Handle>();
            list.add(this.createHandle((GraphicalEditPart)this.getHost(), 20));
            list.add(this.createHandle((GraphicalEditPart)this.getHost(), 12));
            list.add(this.createHandle((GraphicalEditPart)this.getHost(), 9));
            list.add(this.createHandle((GraphicalEditPart)this.getHost(), 17));
            return list;
        }

        Handle createHandle(GraphicalEditPart owner, int direction) {
            SelectHandle handle = new SelectHandle(owner, direction);
            return handle;
        }
    }
}

