/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.ui.editor.figures;

import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.gef.GEFGraphicalViewer;
import org.jboss.tools.jst.web.tiles.ui.TilesUIPlugin;
import org.jboss.tools.jst.web.tiles.ui.editor.TilesEditor;
import org.jboss.tools.jst.web.tiles.ui.editor.edit.DefinitionEditPart;
import org.jboss.tools.jst.web.tiles.ui.editor.figures.NodeFigure;
import org.jboss.tools.jst.web.tiles.ui.editor.figures.xpl.FixedConnectionAnchor;
import org.jboss.tools.jst.web.tiles.ui.editor.model.IDefinition;
import org.jboss.tools.jst.web.tiles.ui.editor.print.PrintIconHelper;

public class DefinitionFigure
extends NodeFigure
implements HandleBounds,
FigureListener,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final Dimension SIZE = new Dimension(114, 21);
    protected Color bgColor = new Color(null, 226, 239, 219);
    public static final Image expandIcon = ImageDescriptor.createFromFile(TilesEditor.class, (String)"icons/tiles_minus.gif").createImage();
    public static final Image collapseIcon = ImageDescriptor.createFromFile(TilesEditor.class, (String)"icons/tiles_plus.gif").createImage();
    private Image icon = null;
    public IDefinition definition;
    private Label label = null;
    String path;
    DefinitionEditPart editPart;
    int width;
    int height;
    private Point oldLocation = null;
    private Point newLocation = null;
    private Point curentLocation = null;
    private int curent = 0;
    private int step = 20;
    private Dimension size = null;
    private boolean animated = false;
    public static Animator animator = new Animator();

    public void setGroupEditPart(DefinitionEditPart part) {
        this.editPart = part;
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
    }

    public void setPath(String path) {
        this.path = path;
        if (this.label != null) {
            this.label.setText(path);
            this.label.setSize(this.label.getPreferredSize());
        }
    }

    public void refreshFont() {
        if (this.label != null) {
            this.label.setText(this.definition.getName());
            this.label.setFont(this.definition.getTilesModel().getOptions().getDefinitionNameFont());
            this.label.setSize(this.label.getPreferredSize());
            this.label.setLocation(new Point(this.getLocation().x + 24, this.getLocation().y - (7 + this.definition.getTilesModel().getOptions().getDefinitionNameFont().getFontData()[0].getHeight())));
        }
    }

    public void setIcon(Image i) {
        this.icon = PrintIconHelper.getPrintImage(i);
    }

    public void addNotify() {
        if (this.definition == null) {
            return;
        }
        this.label = new Label(this.path);
        this.label.setFont(this.definition.getTilesModel().getOptions().getDefinitionNameFont());
        this.getParent().add((IFigure)this.label);
        this.label.setForegroundColor(ColorConstants.black);
        this.label.setOpaque(false);
        this.label.setText(this.path);
        this.label.setVisible(true);
        this.label.setSize(this.label.getPreferredSize());
        this.label.setLocation(new Point(this.getLocation().x + 24, this.getLocation().y - (7 + this.definition.getTilesModel().getOptions().getDefinitionNameFont().getFontData()[0].getHeight())));
        this.label.addMouseListener((MouseListener)this);
        this.addMouseListener(this);
    }

    public void removeNotify() {
        if (this.definition == null) {
            return;
        }
        this.label.removeMouseListener((MouseListener)this);
        this.removeMouseListener(this);
        this.getParent().remove((IFigure)this.label);
    }

    public void figureMoved(IFigure source) {
        if (this.definition != null && this.label != null) {
            this.label.setLocation(new Point(this.getLocation().x + 24, this.getLocation().y - 14));
        }
    }

    public void init(int number) {
        if (number == 0) {
            number = 1;
        }
        int i = 0;
        while (i < number) {
            FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
            c.offsetV = 32 + 16 * i;
            c.leftToRight = false;
            this.connectionAnchors.put(String.valueOf(i + 1) + "_OUT", c);
            this.outputConnectionAnchors.addElement(c);
            ++i;
        }
    }

    public DefinitionFigure(IDefinition definition) {
        this.definition = definition;
        if (definition != null) {
            this.setIcon(definition.getImage());
            this.setPath(definition.getName());
        }
        this.setOpaque(false);
        this.addFigureListener(this);
        this.addKeyListener(this);
        this.setBorder((Border)new GroupBorder(blackColor));
        FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
        c.offsetV = 10;
        c.leftToRight = false;
        this.connectionAnchors.put("1_IN", c);
        this.inputConnectionAnchors.addElement(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetV = 10;
        c.offsetH = -1;
        this.connectionAnchors.put("1_OUT", c);
        this.outputConnectionAnchors.addElement(c);
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getCropped(new Insets(0, 0, 0, 0));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        int width = r.width - 1;
        if (this.definition != null && this.definition.isAnotherTiles()) {
            if (!this.definition.isConfirmed()) {
                g.setBackgroundColor(lightGrayColor);
            } else {
                g.setBackgroundColor(whiteColor);
            }
        } else {
            g.setBackgroundColor(whiteColor);
        }
        g.fillRectangle(1, 1, 22, 19);
        if (this.icon != null) {
            g.drawImage(this.icon, 4, 2);
        }
        if (this.definition != null && this.definition.hasErrors()) {
            g.drawImage(errorIcon, 4, 10);
        }
        if (this.definition != null && this.definition.isAnotherTiles()) {
            if (!this.definition.isConfirmed()) {
                g.setBackgroundColor(lightGrayColor);
            } else {
                g.setBackgroundColor(anotherTilesColor);
            }
        } else {
            g.setBackgroundColor(this.bgColor);
        }
        g.fillRectangle(24, 1, width - 25, 19);
        if (this.definition.isExpanded()) {
            g.drawImage(expandIcon, 98, 6);
        } else if (this.definition.isCollapsed()) {
            g.drawImage(collapseIcon, 98, 6);
        }
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        if (me.button == 3 && me.getSource() == this.label) {
            ((GEFGraphicalViewer)this.editPart.getViewer()).setNoDeselect();
            this.editPart.getViewer().select((EditPart)this.editPart);
        }
        if (me.button == 1 && me.x > 93 + this.getLocation().x && me.x < 114 + this.getLocation().x && me.getSource() == this && this.editPart.getViewer().getEditDomain().getActiveTool() instanceof SelectionTool) {
            if (this.definition.isExpanded()) {
                this.definition.collapse();
            } else if (this.definition.isCollapsed()) {
                this.definition.expand();
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void closeNavigator() {
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void keyPressed(KeyEvent ke) {
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void setBounds(Rectangle rect) {
        this.oldLocation = this.getLocation();
        if (this.oldLocation.x == rect.x && this.oldLocation.y == rect.y) {
            if (this.animated) {
                animator.removeAnimateListener(this);
                this.animated = false;
            }
            return;
        }
        if (this.oldLocation.x == 0 && this.oldLocation.y == 0 || !this.definition.getTilesModel().getOptions().isAnimateLayout()) {
            super.setBounds(rect);
        } else {
            this.curent = 0;
            this.newLocation = new Point(rect.x, rect.y);
            this.curentLocation = this.oldLocation.getCopy();
            this.size = new Dimension(rect.width, rect.height);
            if (!this.animated) {
                animator.addAnimateListener(this);
            }
            this.animated = true;
        }
    }

    public void animate() {
        ++this.curent;
        if (this.curent > 1000) {
            animator.removeAnimateListener(this);
            this.animated = false;
            return;
        }
        double distance = this.oldLocation.getDistance(this.newLocation);
        int steps = (int)distance / this.step;
        if (steps == 0) {
            super.setBounds(new Rectangle(this.newLocation.x, this.newLocation.y, this.size.width, this.size.height));
            animator.removeAnimateListener(this);
            this.animated = false;
            return;
        }
        Dimension difference = this.newLocation.getDifference(this.oldLocation);
        difference.width /= steps;
        difference.height /= steps;
        this.curentLocation.x += difference.width;
        this.curentLocation.y += difference.height;
        if (this.oldLocation.x < this.newLocation.x) {
            if (this.curentLocation.x > this.newLocation.x) {
                this.curentLocation.x = this.newLocation.x;
            }
        } else if (this.curentLocation.x < this.newLocation.x) {
            this.curentLocation.x = this.newLocation.x;
        }
        if (this.oldLocation.y < this.newLocation.y) {
            if (this.curentLocation.y > this.newLocation.y) {
                this.curentLocation.y = this.newLocation.y;
            }
        } else if (this.curentLocation.y < this.newLocation.y) {
            this.curentLocation.y = this.newLocation.y;
        }
        super.setBounds(new Rectangle(this.curentLocation.x, this.curentLocation.y, this.size.width, this.size.height));
        if (this.curentLocation.x == this.newLocation.x && this.curentLocation.y == this.newLocation.y) {
            animator.removeAnimateListener(this);
            this.animated = false;
        }
    }

    public static class Animator
    extends Thread {
        private static List<DefinitionFigure> listeners = new Vector<DefinitionFigure>();

        public Animator() {
            super("");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    if (listeners.size() == 0) {
                        Animator animator = this;
                        synchronized (animator) {
                            this.wait();
                        }
                    }
                    Animator.sleep(10L);
                    this.fireAnimate();
                }
            }
            catch (Exception ex) {
                TilesUIPlugin.getPluginLog().logError((Throwable)ex);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addAnimateListener(DefinitionFigure figure) {
            listeners.add(figure);
            if (listeners.size() == 1) {
                Animator animator = this;
                synchronized (animator) {
                    this.notifyAll();
                }
            }
        }

        public void removeAnimateListener(DefinitionFigure figure) {
            listeners.remove((Object)figure);
        }

        public void fireAnimate() {
            if (listeners.size() == 0 || Display.getDefault() == null) {
                return;
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < listeners.size()) {
                        ((DefinitionFigure)((Object)listeners.get(i))).animate();
                        ++i;
                    }
                }
            });
        }
    }

    class GroupBorder
    extends LineBorder {
        public GroupBorder(Color color) {
            super(color);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle r = GroupBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getCopy();
            graphics.translate(r.getLocation());
            int width = r.width - 1;
            if (DefinitionFigure.this.definition != null && DefinitionFigure.this.definition.isAnotherTiles()) {
                graphics.setForegroundColor(darkGrayColor);
                if (DefinitionFigure.this.definition.isConfirmed()) {
                    graphics.setLineStyle(3);
                }
            } else {
                graphics.setForegroundColor(blackColor);
            }
            graphics.drawLine(1, 0, width - 2, 0);
            graphics.drawLine(width - 1, 1, width - 1, 19);
            graphics.drawLine(23, 0, 23, 20);
            graphics.drawLine(0, 1, 0, 19);
            graphics.drawLine(1, 20, width - 2, 20);
        }
    }
}

