/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.ui.editor.figures;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.jboss.tools.jst.web.tiles.ui.editor.edit.DefinitionEditPart;
import org.jboss.tools.jst.web.tiles.ui.editor.figures.DefinitionFigure;
import org.jboss.tools.jst.web.tiles.ui.editor.figures.DiagramFigure;
import org.jboss.tools.jst.web.tiles.ui.editor.model.IDefinition;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ITilesOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesDiagramLayout
extends AbstractLayout {
    Dimension dim = new Dimension(0, 0);
    Hashtable<IDefinition, Rectangle> figureDim = new Hashtable();
    Hashtable<String, IDefinition> figureNames;
    int figureW = 114;
    int figureH = 21;
    int border = 30;
    ITilesOptions options;
    IFigure container;

    private int getGridX() {
        return this.options.getHorizontalSpacing();
    }

    private int getGridY() {
        return this.options.getVerticalSpacing();
    }

    private List<Object> getDefinitions() {
        return ((DiagramFigure)this.container).getEditPart().getTilesModel().getDefinitionList().getElements();
    }

    private DefinitionFigure getFigure(IDefinition definition) {
        DefinitionEditPart part = (DefinitionEditPart)((DiagramFigure)this.container).getEditPart().getViewer().getEditPartRegistry().get(definition);
        if (part == null) {
            return null;
        }
        return part.getDefinitionFigure();
    }

    public TilesDiagramLayout(ITilesOptions options) {
        this.options = options;
    }

    public Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        this.calculateDim();
        return this.dim;
    }

    private void calculateDim() {
        int x = 0;
        int y = 0;
        Iterator<IDefinition> i = this.figureDim.keySet().iterator();
        while (i.hasNext()) {
            Rectangle fb = this.figureDim.get(i.next());
            x = Math.max(x, fb.x + fb.width);
            y = Math.max(y, fb.y + fb.height);
        }
        this.dim.width = x;
        this.dim.height = y;
    }

    public void layout(IFigure container) {
        this.container = container;
        this.figureDim.clear();
        List<Object> l = this.getDefinitions();
        this.figureNames = new Hashtable();
        Vector<IDefinition> figures = new Vector<IDefinition>();
        int i = 0;
        while (i < l.size()) {
            IDefinition tf = (IDefinition)l.get(i);
            this.figureNames.put(tf.getName(), tf);
            figures.add(tf);
            ++i;
        }
        TreeSet lines = this.createLine(figures, this.figureNames);
        Dimension lineSize = new Dimension(0, 0);
        for (Hashtable hs : lines) {
            int ret = this.layoutLine(hs, lineSize, this.figureNames);
            lineSize.width = 0;
            lineSize.height = ret;
            lineSize.height += this.getGridY();
        }
        int i2 = 0;
        while (i2 < figures.size()) {
            Rectangle r;
            IDefinition tf = (IDefinition)figures.get(i2);
            DefinitionFigure fig = this.getFigure(tf);
            if (fig != null && (r = this.figureDim.get(tf)) != null) {
                fig.setBounds(r);
            }
            ++i2;
        }
        this.calculateDim();
    }

    public int empty(int y, TreeSet ts) {
        int maxY = 0;
        for (Rectangle ry : ts) {
            if (ry.y <= maxY) continue;
            maxY = ry.y;
        }
        int ok = y;
        boolean q = false;
        int i = y;
        while (i <= maxY) {
            for (Rectangle ry : ts) {
                if (ry.contains(ry.x + ry.width / 2, i + ry.height / 2)) {
                    q = false;
                    break;
                }
                q = true;
            }
            ok = i;
            if (q) break;
            i += this.getGridY();
        }
        return ok;
    }

    public int layoutLine(Hashtable h, Dimension fSize, Hashtable names) {
        int ret = fSize.height;
        int www = 0;
        if (h.isEmpty()) {
            return ret;
        }
        Dimension s = new Dimension(fSize);
        TreeSet<String> ts = new TreeSet<String>(new WeightComparator(h));
        for (String name : h.keySet()) {
            ts.add(name);
        }
        for (String name : ts) {
            int ss;
            Hashtable ht = (Hashtable)h.get(name);
            IDefinition tf = (IDefinition)names.get(name);
            if (tf != null) {
                DefinitionFigure fig = this.getFigure(tf);
                if (fig == null) continue;
                if (this.figureDim.containsKey(tf)) {
                    this.figureDim.remove(tf);
                }
                www = 20;
                this.figureDim.put(tf, new Rectangle(new Point(s.width * this.getGridX() + this.border, s.height + this.getGridY() + this.border + s.width * 20), new Dimension(this.figureW, this.figureH)));
                ++s.width;
                ret = this.layoutLine(ht, s, names);
            }
            s.height += this.getGridY() + www;
            s.width = fSize.width;
            s.height = ss = Math.max(s.height, ret);
        }
        return s.height;
    }

    public Hashtable<String, Hashtable> getChilds(IDefinition tf, List<IDefinition> figures, Set<IDefinition> usedFigures) {
        usedFigures.add(tf);
        Hashtable<String, Hashtable> childs = new Hashtable<String, Hashtable>();
        int i = 0;
        while (i < figures.size()) {
            IDefinition tf1 = figures.get(i);
            if (!usedFigures.contains(tf1)) {
                String ex = tf1.getExtends();
                if (tf.getName().equals(ex)) {
                    childs.put(tf1.getName(), this.getChilds(tf1, figures, usedFigures));
                }
            }
            ++i;
        }
        return childs;
    }

    public int getWeight(Hashtable ht) {
        int j = ht.size();
        Iterator i = ht.keySet().iterator();
        while (i.hasNext()) {
            Hashtable h = (Hashtable)ht.get(i.next());
            if (h == null) continue;
            j += this.getWeight(h);
        }
        return j;
    }

    public TreeSet createLine(List<IDefinition> figures, Hashtable figureNames) {
        TreeSet lines = new TreeSet(new WeightComparator());
        HashSet<IDefinition> usedFigures = new HashSet<IDefinition>();
        int i = 0;
        while (i < figures.size()) {
            IDefinition tf = figures.get(i);
            String name = tf.getName();
            String ex = tf.getExtends();
            if (ex == null || "".equals(ex)) {
                Hashtable<String, Hashtable<String, Hashtable>> line = new Hashtable<String, Hashtable<String, Hashtable>>();
                line.put(name, this.getChilds(tf, figures, usedFigures));
                lines.add(line);
            } else {
                Object o = figureNames.get(ex);
                if (o == null) {
                    Hashtable<String, Hashtable<String, Hashtable>> line = new Hashtable<String, Hashtable<String, Hashtable>>();
                    line.put(name, this.getChilds(tf, figures, usedFigures));
                    lines.add(line);
                }
            }
            ++i;
        }
        while (usedFigures.size() < figures.size()) {
            IDefinition tf = null;
            int i2 = 0;
            while (i2 < figures.size() && tf == null) {
                tf = figures.get(i2);
                if (usedFigures.contains(tf)) {
                    tf = null;
                }
                ++i2;
            }
            if (tf == null) break;
            Hashtable<String, Hashtable<String, Hashtable>> line = new Hashtable<String, Hashtable<String, Hashtable>>();
            line.put(tf.getName(), this.getChilds(tf, figures, usedFigures));
            lines.add(line);
        }
        return lines;
    }

    public class WeightComparator
    implements Comparator {
        Hashtable table;

        public WeightComparator(Hashtable table) {
            this.table = table;
        }

        public WeightComparator() {
        }

        public int compare(Object o1, Object o2) {
            int a = 0;
            int b = 0;
            if (o1 instanceof Hashtable && o2 instanceof Hashtable) {
                a = TilesDiagramLayout.this.getWeight((Hashtable)o1);
                b = TilesDiagramLayout.this.getWeight((Hashtable)o2);
            } else {
                a = TilesDiagramLayout.this.getWeight((Hashtable)this.table.get(o1));
                b = TilesDiagramLayout.this.getWeight((Hashtable)this.table.get(o2));
            }
            return a <= b ? 1 : -1;
        }

        public boolean equals(Object obj) {
            return true;
        }
    }
}

