/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.ui.editor.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.tiles.ui.editor.model.IDefinition;
import org.jboss.tools.jst.web.tiles.ui.editor.model.IDefinitionListener;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ILink;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ITilesElement;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ITilesElementList;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ITilesModel;
import org.jboss.tools.jst.web.tiles.ui.editor.model.impl.Link;
import org.jboss.tools.jst.web.tiles.ui.editor.model.impl.TilesElement;
import org.jboss.tools.jst.web.tiles.ui.editor.model.impl.TilesModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Definition
extends TilesElement
implements IDefinition {
    private boolean expanded = true;
    private boolean hidden = false;
    public static final Color DEFAULT_FOREGROUND_COLOR = new Color(null, 0, 0, 0);
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(null, 228, 228, 228);
    protected Color headerForegroundColor = DEFAULT_FOREGROUND_COLOR;
    protected Color headerBackgroundColor = DEFAULT_BACKGROUND_COLOR;
    List<IDefinitionListener> definitionListeners = new Vector<IDefinitionListener>();
    List<ILink> inputLinks = new Vector<ILink>();
    public ILink link = null;
    protected Image icon = null;
    boolean selected = false;

    @Override
    public void collapse() {
        this.expanded = false;
        int i = 0;
        while (i < this.inputLinks.size()) {
            ILink link = this.inputLinks.get(i);
            ((Definition)link.getFromDefinition()).fireLinkRemove(link, 0);
            link.getFromDefinition().hide();
            ++i;
        }
    }

    @Override
    public void hide() {
        this.hidden = true;
        this.expanded = true;
        int i = 0;
        while (i < this.inputLinks.size()) {
            ILink link = this.inputLinks.get(i);
            link.getFromDefinition().hide();
            ((Definition)link.getFromDefinition()).fireLinkRemove(link, 0);
            ++i;
        }
        this.getTilesModel().setHidden(this);
        ((TilesModel)this.getTilesModel()).fireDefinitionRemove(this, 0);
    }

    @Override
    public void expand() {
        ILink link;
        this.expanded = true;
        int i = 0;
        while (i < this.inputLinks.size()) {
            link = this.inputLinks.get(i);
            link.getFromDefinition().visible();
            ++i;
        }
        i = 0;
        while (i < this.inputLinks.size()) {
            link = this.inputLinks.get(i);
            ((Definition)link.getFromDefinition()).fireLinkAdd(link);
            ++i;
        }
    }

    @Override
    public void visible() {
        ILink link;
        this.hidden = false;
        this.getTilesModel().setVisible(this);
        ((TilesModel)this.getTilesModel()).fireDefinitionAdd(this);
        int i = 0;
        while (i < this.inputLinks.size()) {
            link = this.inputLinks.get(i);
            link.getFromDefinition().visible();
            ++i;
        }
        i = 0;
        while (i < this.inputLinks.size()) {
            link = this.inputLinks.get(i);
            ((Definition)link.getFromDefinition()).fireLinkAdd(link);
            ++i;
        }
    }

    @Override
    public List getVisibleInputLinks() {
        if (this.expanded && !this.hidden) {
            return this.inputLinks;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isExpanded() {
        if (this.inputLinks.size() > 0) {
            return this.expanded;
        }
        return false;
    }

    @Override
    public boolean isCollapsed() {
        return !this.expanded;
    }

    @Override
    public boolean hasErrors() {
        return this.getTilesModel().getHelper().hasErrors((XModelObject)this.getSource());
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.definitionListeners != null) {
            this.definitionListeners.clear();
        }
        this.definitionListeners = null;
        if (this.inputLinks != null) {
            this.inputLinks.clear();
        }
        this.inputLinks = null;
    }

    @Override
    public void addInputLink(ILink link) {
        if (!this.inputLinks.contains(link)) {
            this.inputLinks.add(link);
        }
    }

    @Override
    public void removeInputLink(ILink link) {
        this.inputLinks.remove(link);
    }

    public Definition(ITilesModel model, XModelObject groupNode) {
        super(model, groupNode);
        this.icon = EclipseResourceUtil.getImage((XModelObject)groupNode);
        XModelObject[] objects = model.getHelper().getOutputs(groupNode);
        if (objects.length > 0) {
            this.link = new Link(this, objects[0]);
        }
    }

    @Override
    public Image getImage() {
        return this.icon;
    }

    @Override
    public String getExtends() {
        if (this.link != null && this.link.getToDefinition() != null) {
            return this.link.getToDefinition().getName();
        }
        return "";
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean set) {
        boolean oldValue = this.selected;
        this.selected = set;
        this.propertyChangeSupport.firePropertyChange("selected", oldValue, set);
        if (set) {
            this.getTilesModel().setSelectedDefinition(this);
        }
    }

    @Override
    public void clearSelection() {
        ITilesElementList list = this.getTilesModel().getDefinitionList();
        int i = 0;
        while (i < list.size()) {
            IDefinition activity = (IDefinition)list.get(i);
            activity.setSelected(false);
            ++i;
        }
    }

    public ILink[] getLinks() {
        return this.getInputLinks();
    }

    @Override
    public ILink[] getInputLinks() {
        return (ILink[])this.inputLinks.toArray();
    }

    @Override
    public List<ILink> getListInputLinks() {
        return this.inputLinks;
    }

    @Override
    public ILink getLink() {
        return this.link;
    }

    public void fireDefinitionChange() {
        if (this.definitionListeners.size() == 0) {
            return;
        }
        ArrayList<IDefinitionListener> targets = new ArrayList<IDefinitionListener>();
        targets.addAll(this.definitionListeners);
        int i = 0;
        while (i < targets.size()) {
            IDefinitionListener listener = (IDefinitionListener)targets.get(i);
            if (listener != null) {
                listener.definitionChange();
            }
            ++i;
        }
    }

    public void fireLinkAdd(ILink link) {
        ArrayList<IDefinitionListener> listeners = new ArrayList<IDefinitionListener>();
        listeners.addAll(this.definitionListeners);
        int i = 0;
        while (i < listeners.size()) {
            IDefinitionListener listener = (IDefinitionListener)listeners.get(i);
            if (listener != null && listener.isDefinitionListenerEnable()) {
                ((IDefinitionListener)listeners.get(i)).linkAdd(link);
            }
            ++i;
        }
    }

    public void fireLinkRemove(ILink link, int index) {
        ArrayList<IDefinitionListener> listeners = new ArrayList<IDefinitionListener>();
        listeners.addAll(this.definitionListeners);
        int i = 0;
        while (i < listeners.size()) {
            IDefinitionListener listener = (IDefinitionListener)listeners.get(i);
            if (listener != null && listener.isDefinitionListenerEnable()) {
                ((IDefinitionListener)listeners.get(i)).linkRemove(link);
            }
            ++i;
        }
    }

    @Override
    public void addDefinitionListener(IDefinitionListener listener) {
        this.definitionListeners.add(listener);
    }

    @Override
    public void removeDefinitionListener(IDefinitionListener listener) {
        this.definitionListeners.remove(listener);
    }

    @Override
    public void removeFromTilesModel() {
    }

    @Override
    public void remove() {
        if (this.link != null) {
            ILink l = this.link;
            this.link.getToDefinition().removeInputLink(this.link);
            this.link.remove();
            this.link = null;
            this.fireLinkRemove(l, 0);
        }
    }

    @Override
    public void nodeChanged(Object eventData) {
        this.fireDefinitionChange();
        this.propertyChangeSupport.firePropertyChange("name", "", this.getSourceProperty("name"));
    }

    public void addLink(ILink link) {
        this.link = link;
        if (!link.setTarget()) {
            link = null;
        }
    }

    public void removeLink(ILink lin) {
        ILink l = this.link;
        this.link.getToDefinition().removeInputLink(this.link);
        this.link.remove();
        this.link = null;
        this.fireLinkRemove(l, 0);
    }

    @Override
    public void structureChanged(Object eventData) {
    }

    @Override
    public void nodeAdded(Object eventData) {
        XModelObject[] objects = this.getTilesModel().getHelper().getOutputs(this.source);
        if (objects.length > 0 && this.link == null) {
            this.link = new Link(this, objects[0]);
            if (!this.link.setTarget()) {
                this.link = null;
            }
        }
    }

    @Override
    public void nodeRemoved(Object eventData) {
        XModelTreeEvent event = (XModelTreeEvent)eventData;
        ITilesElement removedLink = this.getFromMap(event.getInfo());
        if (removedLink == this.link) {
            ILink l = this.link;
            this.link.getToDefinition().removeInputLink(this.link);
            this.link.remove();
            this.link = null;
            this.fireLinkRemove(l, 0);
        }
    }

    public boolean isElementListListenerEnable() {
        return true;
    }

    public void setElementListListenerEnable(boolean set) {
    }

    @Override
    public boolean isConfirmed() {
        return !this.tilesModel.getHelper().isUnconfirmedItem(this.source);
    }

    @Override
    public boolean isAnotherTiles() {
        return this.tilesModel.getHelper().isNotDefinedInThisFile(this.source);
    }
}

