/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.ui.editor.model.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.action.XModelObjectActionList;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTSync;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.tiles.TilesPreference;
import org.jboss.tools.jst.web.tiles.model.helpers.TilesStructureHelper;
import org.jboss.tools.jst.web.tiles.ui.TilesUIPlugin;
import org.jboss.tools.jst.web.tiles.ui.editor.model.IDefinition;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ILink;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ITilesElement;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ITilesElementList;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ITilesModel;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ITilesModelListener;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ITilesOptions;
import org.jboss.tools.jst.web.tiles.ui.editor.model.impl.Definition;
import org.jboss.tools.jst.web.tiles.ui.editor.model.impl.TilesElement;
import org.jboss.tools.jst.web.tiles.ui.editor.model.impl.TilesElementList;
import org.jboss.tools.jst.web.tiles.ui.preferences.TilesEditorTabbedPreferencesPage;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesModel
extends TilesElement
implements ITilesModel,
PropertyChangeListener,
XModelTreeListener {
    List<IDefinition> visibleDefinitions = new Vector<IDefinition>();
    static final int DEFAULT_VERTICAL_SPACING = 20;
    static final int DEFAULT_HORIZONTAL_SPACING = 185;
    protected List<ITilesModelListener> strutsModelListeners = new Vector<ITilesModelListener>();
    protected TilesHashtable map = new TilesHashtable();
    protected TilesElementList definitionList = new DefinitionList();
    protected TilesStructureHelper helper = TilesStructureHelper.instance;
    protected TilesOptions options;
    protected boolean modified = false;
    IDefinition selectedDefinition = null;
    XModelTreeListenerSWTSync listener = null;

    @Override
    public List<IDefinition> getVisibleDefinitionList() {
        return this.visibleDefinitions;
    }

    @Override
    public void setHidden(IDefinition definition) {
        this.visibleDefinitions.remove(definition);
        this.fireDefinitionRemove(definition, 0);
    }

    @Override
    public void setVisible(IDefinition definition) {
        this.visibleDefinitions.add(definition);
        this.fireDefinitionAdd(definition);
    }

    public TilesModel() {
        try {
            this.setName(WebUIMessages.STRUTS_MODEL);
        }
        catch (PropertyVetoException ex) {
            TilesUIPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    @Override
    public void dispose() {
        this.disconnectFromModel();
        if (this.map != null) {
            this.map.dispose();
        }
        this.map = null;
        if (this.strutsModelListeners != null) {
            this.strutsModelListeners.clear();
        }
        this.strutsModelListeners = null;
        if (this.definitionList != null) {
            this.definitionList.dispose();
        }
        this.definitionList = null;
        if (this.options != null) {
            this.options.dispose();
        }
        this.options = null;
    }

    public boolean isBorderPaint() {
        return false;
    }

    @Override
    public ITilesOptions getOptions() {
        return this.options;
    }

    public TilesModel(Object data) throws SAXException {
        this();
        this.setData(data);
        this.map.setData((XModelObject)data);
    }

    @Override
    public void updateLinks() {
        int i = 0;
        while (i < this.getDefinitionList().size()) {
            IDefinition definition = (IDefinition)this.getDefinitionList().get(i);
            if (definition.getLink() != null) {
                definition.getLink().setTarget();
            }
            ++i;
        }
    }

    public Object get(String name) {
        return null;
    }

    public void put(String name, Object value) {
    }

    @Override
    public TilesStructureHelper getHelper() {
        return this.helper;
    }

    public int getProcessItemCounter() {
        return this.definitionList.size();
    }

    public IDefinition getDefinition(int index) {
        return (IDefinition)this.definitionList.get(index);
    }

    @Override
    public IDefinition getDefinition(String groupName) {
        return (IDefinition)this.definitionList.get(groupName);
    }

    @Override
    public IDefinition getDefinition(Object source) {
        IDefinition[] is = this.definitionList.elements.toArray(new IDefinition[0]);
        int i = 0;
        while (i < is.length) {
            if (is[i].getSource() == source) {
                return is[i];
            }
            ++i;
        }
        return null;
    }

    public void removeGroup(String moduleName) {
    }

    public void removeGroup(IDefinition removeProcessItem) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
    }

    @Override
    public void setSelectedDefinition(IDefinition group) {
        IDefinition oldValue = this.selectedDefinition;
        this.selectedDefinition = group;
        this.propertyChangeSupport.firePropertyChange("selectedProcessItem", oldValue, group);
    }

    @Override
    public IDefinition getSelectedDefinition() {
        return this.selectedDefinition;
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public void setData(Object data) {
        this.source = this.helper.getProcess((XModelObject)data);
        if (this.source == null) {
            return;
        }
        this.map.put(this.source.getPath(), this);
        this.definitionList = new DefinitionList(this.source);
        this.listener = new XModelTreeListenerSWTSync((XModelTreeListener)this);
        this.source.getModel().addModelTreeListener((XModelTreeListener)this.listener);
        this.options = new TilesOptions();
    }

    public void disconnectFromModel() {
        if (this.listener != null) {
            this.source.getModel().removeModelTreeListener((XModelTreeListener)this.listener);
        }
        if (this.options != null) {
            this.options.disconnectFromModel();
        }
        if (this.map != null) {
            this.map.disconnectFromModel();
        }
    }

    @Override
    public boolean isEditable() {
        return this.source != null && this.source.getModelEntity().isEditable(this.source, "body");
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean set) {
        boolean oldValue = this.modified;
        this.modified = set;
        this.propertyChangeSupport.firePropertyChange("modified", oldValue, this.modified);
    }

    public void fireProcessChanged() {
        if (this.strutsModelListeners == null) {
            return;
        }
        ArrayList<ITilesModelListener> targets = new ArrayList<ITilesModelListener>();
        targets.addAll(this.strutsModelListeners);
        int i = 0;
        while (i < targets.size()) {
            ITilesModelListener listener = (ITilesModelListener)targets.get(i);
            if (listener != null) {
                listener.processChanged();
            }
            ++i;
        }
        this.setModified(true);
    }

    public void fireDefinitionAdd(IDefinition newDefinition) {
        ArrayList<ITilesModelListener> targets = new ArrayList<ITilesModelListener>();
        targets.addAll(this.strutsModelListeners);
        int i = 0;
        while (i < targets.size()) {
            ITilesModelListener listener = (ITilesModelListener)targets.get(i);
            if (listener != null) {
                listener.definitionAdd(newDefinition);
            }
            ++i;
        }
        this.setModified(true);
    }

    public void fireDefinitionRemove(IDefinition newDefinition, int index) {
        ArrayList<ITilesModelListener> targets = new ArrayList<ITilesModelListener>();
        targets.addAll(this.strutsModelListeners);
        int i = 0;
        while (i < targets.size()) {
            ITilesModelListener listener = (ITilesModelListener)targets.get(i);
            if (listener != null) {
                listener.definitionRemove(newDefinition);
            }
            ++i;
        }
        this.setModified(true);
    }

    public void fireLinkAdd(ILink newLink) {
        ArrayList<ITilesModelListener> targets = new ArrayList<ITilesModelListener>();
        targets.addAll(this.strutsModelListeners);
        int i = 0;
        while (i < targets.size()) {
            ITilesModelListener listener = (ITilesModelListener)targets.get(i);
            if (listener != null) {
                listener.linkAdd(newLink);
            }
            ++i;
        }
        this.setModified(true);
    }

    public void fireLinkRemove(ILink newLink) {
        ArrayList<ITilesModelListener> targets = new ArrayList<ITilesModelListener>();
        targets.addAll(this.strutsModelListeners);
        int i = 0;
        while (i < targets.size()) {
            ITilesModelListener listener = (ITilesModelListener)targets.get(i);
            if (listener != null) {
                listener.linkRemove(newLink);
            }
            ++i;
        }
        this.setModified(true);
    }

    @Override
    public void addTilesModelListener(ITilesModelListener listener) {
        this.strutsModelListeners.add(listener);
    }

    @Override
    public void removeTilesModelListener(ITilesModelListener listener) {
        if (this.strutsModelListeners != null) {
            this.strutsModelListeners.remove(listener);
        }
    }

    @Override
    public void remove() {
    }

    @Override
    public ITilesElementList getDefinitionList() {
        return this.definitionList;
    }

    public void nodeChanged(XModelTreeEvent event) {
        String path;
        if (this.map == null) {
            return;
        }
        this.fireProcessChanged();
        TilesElement element = (TilesElement)this.map.get(event.getInfo());
        if (element != null && !event.getModelObject().getPath().equals(event.getInfo())) {
            this.updateCash((String)event.getInfo());
        }
        ITilesElement iTilesElement = element = (path = event.getModelObject().getPath()) == null ? null : this.map.get(path);
        if (element == null) {
            return;
        }
        element.nodeChanged(event);
    }

    public void structureChanged(XModelTreeEvent event) {
        String obj = event.getModelObject().getPath();
        if (obj == null) {
            return;
        }
        if (this.map == null) {
            return;
        }
        TilesElement element = (TilesElement)this.map.get(obj);
        if (element == null) {
            return;
        }
        if (event.kind() == 3) {
            element.structureChanged(event);
        } else if (event.kind() == 1) {
            element.nodeAdded(event);
        } else if (event.kind() == 2) {
            element.nodeRemoved(event);
        }
    }

    public void putToMap(Object key, Object value) {
        this.getMap().put(key, value);
    }

    @Override
    public void removeFromMap(Object key) {
        this.getMap().remove(key);
    }

    @Override
    public ITilesElement getFromMap(Object key) {
        return this.getMap().get(key);
    }

    @Override
    public TilesHashtable getMap() {
        return this.map;
    }

    @Override
    public ITilesElement findElement(String key) {
        return this.map.get(key);
    }

    protected void clearCash(String path) {
        this.updateCash(path, true);
    }

    protected void updateCash(String path) {
        this.updateCash(path, false);
    }

    protected void updateCash(String path, boolean clear) {
        String rpath = String.valueOf(path) + "/";
        Object[] ks = this.map.map.keySet().toArray();
        int i = 0;
        while (i < ks.length) {
            if (ks[i].equals(path) || ks[i].toString().startsWith(rpath)) {
                XModelObject o;
                ITilesElement n = (ITilesElement)this.map.map.get(ks[i]);
                this.map.map.remove(ks[i]);
                if (!clear && (o = (XModelObject)n.getSource()).isActive()) {
                    this.map.map.put(o.getPath(), n);
                }
            }
            ++i;
        }
    }

    @Override
    public Menu getPopupMenu(Control control, Object environment) {
        if (this.source == null) {
            return null;
        }
        if (this.source.getModelEntity().getActionList().getActionItems().length != 0) {
            XModelObjectActionList l = new XModelObjectActionList(this.source.getModelEntity().getActionList(), this.source, null, environment);
            Menu menu = l.createMenu(control);
            return menu;
        }
        return null;
    }

    @Override
    public Menu getPopupMenu(Control control) {
        return this.getPopupMenu(control, null);
    }

    @Override
    public boolean isConfirmed() {
        return true;
    }

    public class DefinitionList
    extends TilesElementList {
        protected DefinitionList() {
        }

        public DefinitionList(XModelObject processItemSource) {
            super(TilesModel.this, TilesModel.this.source);
            if (((XModelObject)TilesModel.this.getSource()).getPath() == null) {
                return;
            }
            XModelObject[] definitionNodeList = TilesModel.this.getHelper().getItems(processItemSource);
            int i = 0;
            while (i < definitionNodeList.length) {
                Definition newDefinition = new Definition(TilesModel.this, definitionNodeList[i]);
                newDefinition.addPropertyChangeListener("selected", new DefinitionPropertyChangeListener());
                this.add(newDefinition);
                TilesModel.this.visibleDefinitions.add(newDefinition);
                ++i;
            }
        }

        public void structureChanged(Object eventData) {
        }

        public void nodeAdded(Object eventData) {
            XModelTreeEvent event = (XModelTreeEvent)eventData;
            Definition newProcessItem = new Definition(TilesModel.this, (XModelObject)event.getInfo());
            this.add(newProcessItem);
            TilesModel.this.visibleDefinitions.add(newProcessItem);
            TilesModel.this.fireDefinitionAdd(newProcessItem);
        }

        public void nodeRemoved(Object eventData) {
            XModelTreeEvent event = (XModelTreeEvent)eventData;
            ITilesElement removedProcessItem = this.getFromMap(event.getInfo());
            int index = this.indexOf(removedProcessItem);
            removedProcessItem.remove();
            this.remove(removedProcessItem);
            TilesModel.this.visibleDefinitions.remove(removedProcessItem);
            this.removeFromMap(((XModelTreeEvent)eventData).getInfo());
            TilesModel.this.fireDefinitionRemove((Definition)removedProcessItem, index);
            TilesModel.this.clearCash((String)event.getInfo());
        }
    }

    public class DefinitionPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            IDefinition processItem = (IDefinition)event.getSource();
            if (event.getPropertyName().equals("selected") && ((Boolean)event.getNewValue()).booleanValue()) {
                TilesModel.this.setSelectedDefinition(processItem);
            }
        }
    }

    public class TilesHashtable
    implements XModelTreeListener {
        Hashtable<Object, Object> map = new Hashtable();
        XModelObject source;
        String name;

        public void dispose() {
            this.disconnectFromModel();
            if (this.map != null) {
                this.map.clear();
            }
            this.map = null;
        }

        public void put(Object key, Object value) {
            this.map.put(key, value);
        }

        public void setData(XModelObject data) {
            this.source = data;
            this.source.getModel().addModelTreeListener((XModelTreeListener)this);
            this.name = this.source.getAttributeValue("name");
        }

        public void disconnectFromModel() {
            this.source.getModel().removeModelTreeListener((XModelTreeListener)this);
        }

        public ITilesElement get(Object key) {
            return (ITilesElement)this.map.get(key);
        }

        public void remove(Object key) {
            this.map.remove(key);
        }

        public void nodeChanged(XModelTreeEvent event) {
            if (!this.source.getAttributeValue("name").equals(this.name)) {
                this.name = this.source.getAttributeValue("name");
                Enumeration<Object> keys = this.map.keys();
                while (keys.hasMoreElements()) {
                    String path = (String)keys.nextElement();
                    TilesElement element = (TilesElement)this.map.get(path);
                    if (element == null || element.getSource() == null) continue;
                    this.map.remove(path);
                    this.map.put(((XModelObject)element.getSource()).getPath(), element);
                }
            }
        }

        public void structureChanged(XModelTreeEvent event) {
        }
    }

    class TilesOptions
    implements XModelTreeListener,
    ITilesOptions {
        XModelObject optionsObject = ModelUtilities.getPreferenceModel().getByPath(TilesEditorTabbedPreferencesPage.TILES_EDITOR_PATH);
        XModelTreeListenerSWTSync optionsListener = new XModelTreeListenerSWTSync((XModelTreeListener)this);
        Font definitionNameFont = null;

        public TilesOptions() {
            this.optionsObject.getModel().addModelTreeListener((XModelTreeListener)this.optionsListener);
        }

        public void dispose() {
            this.disconnectFromModel();
            if (this.definitionNameFont != null && this.definitionNameFont.isDisposed()) {
                this.definitionNameFont.dispose();
            }
            this.definitionNameFont = null;
        }

        public int getVerticalSpacing() {
            String str = TilesPreference.VERTICAL_SPACING.getValue();
            if (str == null) {
                return 20;
            }
            if (str.indexOf("default") >= 0) {
                return 20;
            }
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                TilesUIPlugin.getPluginLog().logError((Throwable)ex);
                return 20;
            }
        }

        public int getHorizontalSpacing() {
            String str = TilesPreference.HORIZONTAL_SPACING.getValue();
            if (str == null) {
                return 185;
            }
            if (str.indexOf("default") >= 0) {
                return 185;
            }
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                TilesUIPlugin.getPluginLog().logError((Throwable)ex);
                return 185;
            }
        }

        public String getAlignment() {
            String str = TilesPreference.TILES_ALIGNMENT.getValue();
            return str;
        }

        public boolean isAnimateLayout() {
            String str = TilesPreference.TILES_ANIMATION.getValue();
            return str != null && str.equals("yes");
        }

        public Font getDefinitionNameFont() {
            String name;
            int size = 8;
            int style = 1;
            String str = TilesPreference.DEFINITION_NAME_FONT.getValue();
            int pos = str.indexOf(",");
            if (pos < 0) {
                name = str;
            } else {
                int pos3;
                name = str.substring(0, pos);
                int pos2 = str.indexOf("size=");
                if (pos2 >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    size = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 5, str.length())) : Integer.parseInt(str.substring(pos2 + 5, pos3));
                }
                if ((pos2 = str.indexOf("style=")) >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    style = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 6, str.length())) : Integer.parseInt(str.substring(pos2 + 6, pos3));
                }
            }
            if (this.definitionNameFont == null) {
                this.definitionNameFont = new Font(null, name, size, style);
            } else if (!this.definitionNameFont.getFontData()[0].getName().equals(name) || this.definitionNameFont.getFontData()[0].getHeight() != size || this.definitionNameFont.getFontData()[0].getStyle() != style) {
                this.definitionNameFont = new Font(null, name, size, style);
            }
            return this.definitionNameFont;
        }

        public void disconnectFromModel() {
            this.optionsObject.getModel().removeModelTreeListener((XModelTreeListener)this.optionsListener);
            if (this.optionsListener != null) {
                this.optionsListener.dispose();
            }
            this.optionsListener = null;
        }

        public void nodeChanged(XModelTreeEvent event) {
            TilesModel.this.fireProcessChanged();
            int i = 0;
            while (i < TilesModel.this.getDefinitionList().size()) {
                Definition definition = (Definition)TilesModel.this.getDefinitionList().get(i);
                definition.fireDefinitionChange();
                ++i;
            }
        }

        public void structureChanged(XModelTreeEvent event) {
        }
    }
}

