/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.TypedEvent;
import org.jboss.tools.common.model.ui.editors.dnd.context.DropContext;
import org.jboss.tools.common.model.ui.editors.dnd.context.IDNDTextEditor;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIDragService;
import org.mozilla.interfaces.nsIDragSession;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsITransferable;
import org.mozilla.xpcom.Mozilla;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DndUtil {
    public static final String kTextMime = "text/plain";
    public static final String kUnicodeMime = "text/unicode";
    public static final String kHTMLMime = "text/html";
    public static final String kAOLMailMime = "AOLMAIL";
    public static final String kPNGImageMime = "image/png";
    public static final String kJPEGImageMime = "image/jpg";
    public static final String kGIFImageMime = "image/gif";
    public static final String kFileMime = "application/x-moz-file";
    public static final String kURLMime = "text/x-moz-url";
    public static final String kURLDataMime = "text/x-moz-url-data";
    public static final String kURLDescriptionMime = "text/x-moz-url-desc";
    public static final String kNativeImageMime = "application/x-moz-nativeimage";
    public static final String kNativeHTMLMime = "application/x-moz-nativehtml";
    public static final String kFilePromiseURLMime = "application/x-moz-file-promise-url";
    public static final String kFilePromiseMime = "application/x-moz-file-promise";
    public static final String kFilePromiseDirectoryMime = "application/x-moz-file-promise-dir";
    public static final String[] FLAVORS = new String[]{"vpe/model", "text/plain", "text/unicode", "text/html", "AOLMAIL", "image/png", "image/jpg", "image/gif", "application/x-moz-file", "text/x-moz-url", "text/x-moz-url-data", "text/x-moz-url-desc", "application/x-moz-nativeimage", "application/x-moz-nativehtml", "application/x-moz-file-promise-url", "application/x-moz-file-promise", "application/x-moz-file-promise-dir"};

    private DndUtil() {
    }

    public static void fireDnDEvent(DropContext dropContext, IDNDTextEditor textEditor, TypedEvent event) {
        dropContext.runDropCommand(textEditor, event);
    }

    public static DragTransferData getDragTransferData() {
        nsIDragSession dragSession = DndUtil.getCurrentDragSession();
        List<String> supportedDataFlavors = DndUtil.getSupportedDataFlavors(dragSession);
        nsITransferable iTransferable = DndUtil.createTransferable(supportedDataFlavors);
        String[] aFlavor = new String[1];
        nsISupports[] aValue = new nsISupports[1];
        long[] aDataLen = new long[1];
        dragSession.getData(iTransferable, 0L);
        iTransferable.getAnyTransferData(aFlavor, aValue, aDataLen);
        return new DragTransferData(aFlavor[0], aValue[0], aDataLen[0]);
    }

    public static nsITransferable createTransferable(List<String> supportedDataFlavors) {
        nsIComponentManager componentManager = Mozilla.getInstance().getComponentManager();
        nsITransferable iTransferable = (nsITransferable)componentManager.createInstanceByContractID("@mozilla.org/widget/transferable;1", null, "{8b5314bc-db01-11d2-96ce-0060b0fb9956}");
        for (String flavor : supportedDataFlavors) {
            iTransferable.addDataFlavor(flavor);
        }
        return iTransferable;
    }

    private static List<String> getSupportedDataFlavors(nsIDragSession dragSession) {
        ArrayList<String> supportedDataFlavors = new ArrayList<String>();
        String[] stringArray = FLAVORS;
        int n = FLAVORS.length;
        int n2 = 0;
        while (n2 < n) {
            String flavor = stringArray[n2];
            if (dragSession.isDataFlavorSupported(flavor)) {
                supportedDataFlavors.add(flavor);
            }
            ++n2;
        }
        return supportedDataFlavors;
    }

    public static nsIDragSession getCurrentDragSession() {
        nsIServiceManager serviceManager = Mozilla.getInstance().getServiceManager();
        nsIDragService dragService = (nsIDragService)serviceManager.getServiceByContractID("@mozilla.org/widget/dragservice;1", "{82b58ada-f490-4c3d-b737-1057c4f1d052}");
        nsIDragSession dragSession = dragService.getCurrentSession();
        return dragSession;
    }

    public static class DragTransferData {
        private final String flavor;
        private final long dataLen;
        private final nsISupports value;

        public DragTransferData(String flavor, nsISupports value, long dataLen) {
            this.flavor = flavor;
            this.value = value;
            this.dataLen = dataLen;
        }

        public String getFlavor() {
            return this.flavor;
        }

        public nsISupports getValue() {
            return this.value;
        }

        public long getDataLen() {
            return this.dataLen;
        }
    }
}

