/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.w3c.dom.Node;

public class VpeDomBuilder {
    protected VpeDomMapping domMapping;
    private INodeAdapter sorceAdapter;
    private List sourceNodes = new ArrayList();

    public VpeDomBuilder(VpeDomMapping domMapping, INodeAdapter sorceAdapter) {
        this.domMapping = domMapping;
        this.sorceAdapter = sorceAdapter;
    }

    public VpeDomMapping getDomMapping() {
        return this.domMapping;
    }

    public VpeTemplateManager getTemplateManager() {
        return VpeTemplateManager.getInstance();
    }

    public void registerNodes(VpeNodeMapping nodeMapping) {
        if (this.sorceAdapter == null) {
            return;
        }
        this.domMapping.mapNodes(nodeMapping);
        Node sourceNode = nodeMapping.getSourceNode();
        if (((INodeNotifier)sourceNode).getExistingAdapter((Object)this.sorceAdapter) == null) {
            ((INodeNotifier)sourceNode).addAdapter(this.sorceAdapter);
            this.sourceNodes.add(sourceNode);
        }
    }

    public void dispose() {
        for (INodeNotifier sourceNode : this.sourceNodes) {
            if (sourceNode == null) continue;
            sourceNode.removeAdapter(this.sorceAdapter);
        }
        this.sourceNodes.clear();
    }

    public INodeAdapter getSorceAdapter() {
        return this.sorceAdapter;
    }

    public List getSourceNodes() {
        return this.sourceNodes;
    }
}

